package com.wangxiaolu.promotion.domain.user.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import java.time.LocalDateTime;

/**
 * 微信门店数据延迟保存临时表实体
 */
@Data
@TableName("wx_temporary_info_delay")
public class WxTemporaryInfoDelayDO {
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 微信OpenId
     */
    private String openId;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店地址
     */
    private String storeAddress;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 数据暂存时间
     */
    private LocalDateTime createTime;

    /**
     * 是否已处理：0-未处理 1-已处理
     */
    private Integer isProcessed;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}