package com.wangxiaolu.promotion.controller.user.qince;

import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.QinCeDataTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-03-29 16
 * @describe : 勤策同步数据接口
 */
@RestController
@RequestMapping("/user/qince/task")
public class QinCeDataTaskController {

    @Autowired
    QinCeDataTaskService qinCeDataTaskService;

    /**
     * 同步组织架构/部门数据
     */
    @GetMapping("/department")
    public R departmentTask(){
        qinCeDataTaskService.departmentSyncTask();
        return R.success();
    }

    /**
     * 同步员工数据
     */
    @GetMapping("/employee")
    public R employeeTask(){
        qinCeDataTaskService.employeeSyncTask();
        return R.success();
    }

    /**
     * 同步[终端数据]
     */
    @GetMapping("/shops")
    public R shopDetailAllTask(){
        qinCeDataTaskService.shopDetailAllTask();
        return R.success();
    }


}
