package com.wangxiaolu.promotion.domain.activity.dao;

import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryPhotoWrapper;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityPhotoDto;

import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-05-09 11
 * @describe :
 */
public interface TemporaryActivityPhotoDao {

    /**
     * 保存活动上报照片list
     */
    void saveReportedList(Long temporaryId, Long reportedId, Integer photoType, List<String> urls, List<String> changeUrls);
    void saveReportedList(Long clockId,Long temporaryId, Long reportedId, Integer photoType, List<String> urls);

    /**
     * 保存促销员上下班打卡图片
     */
    void saveClockPhoto(Long temporaryId, Long clockId, Integer photoType, String url);

    /**
     * 根据促销员id-活动上报id查询图片
     */
    Map<Integer, List<String>> findReportedGroup(Long temporaryId, Long reportedId);

    Map<Integer, TemporaryActivityPhotoDto> findClockPhotoGroupByClockId(Long clockId);

    void updateStatus(TemporaryPhotoWrapper pw, int status);

    void saveClockPhotoByUpdate(Long temporaryId, Long id, Integer photoType, String url);

    Map<Long, Map<Integer, String>> findClockPhotoGroupByClockIds(List<Long> clockIds);

    Map<Integer, List<TemporaryActivityPhotoDto>> findReportedInfoGroup(Long temporaryId, Long reportedId);

    void deleteList(Long reportedId, int type);

    void saveClockTaskPhoto(TemporaryActivityPhotoDto dto, List<String> clockPhtos);

    List<TemporaryActivityPhotoDto> selectPhotos(TemporaryPhotoWrapper clockId);

    void deleteListByClockId(Long clockId, Integer taskType);
}
