package com.wangxiaolu.promotion.controller.activity.manage.activityplan;

import com.wangxiaolu.promotion.common.util.NumberUtils;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanRecordDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanInfoVo;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanRecordCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-08-20 13
 * @describe : 活动计划上传记录
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/plan/core")
public class ActivityPlanRecordCoreController {

    @Autowired
    ActivityPlanRecordCoreService activityPlanRecordCoreService;

    /**
     * 上传活动计划表
     */
    @PostMapping("/push/excel")
    public R pushPlanExcel(@RequestBody ActivityPlanVo activityPlanVo) {
        try {
            EmployeeActivityPlanRecordDto planDto = new EmployeeActivityPlanRecordDto();
            BeanUtils.copyProperties(activityPlanVo, planDto);
            planDto.setCreateDate(new Date());

            String[] urlArr = activityPlanVo.getExcelUrl().split("weda-uploader/");
            String fileId = urlArr[urlArr.length - 1];

            if (fileId.length() > 53){
                throw new DataException(RCode.ACTIVITY_PLAN_FILENAME_LONG);
            }

            planDto.setExcelFiledId(fileId);
            activityPlanRecordCoreService.saveActivityPlan(planDto, activityPlanVo);
            return R.success();
        } catch (Exception e) {
            return R.fail(e.getMessage());
        }
    }

    /**
     * 活动店铺转让
     */
    @PutMapping("/transfer")
    public R transferActivityPlan(@RequestBody ActivityPlanVo activityPlanVo) {
        if (Objects.isNull(activityPlanVo.getOriginalEmpId()) || Objects.isNull(activityPlanVo.getTransferEmpId())){
            throw new ParamException(RCode.CHARGER_ID_ERROR);
        }
        activityPlanRecordCoreService.transferActivityPlan(activityPlanVo);

        return R.success();
    }

    @DeleteMapping("/delete/{id}")
    public R deleteActivityPlanById(@PathVariable Long id){
        if (NumberUtils.isNull(id)){
            throw new DataException(RCode.API_DATA_ERROR);
        }
        activityPlanRecordCoreService.deleteById(id);
        return R.success();
    }
}
