package com.wangxiaolu.promotion.service.activity.employee.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.activity.dao.PromotionStoreDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.PromotionStoreWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.service.activity.employee.EmpPromotionStoreQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-26 16
 * @describe :
 */
@Service
public class EmpPromotionStoreQueryServiceImpl implements EmpPromotionStoreQueryService {

    @Autowired
    PromotionStoreDao promotionStoreDao;


    @Override
    public void findStorePage(PageInfo pageInfo) {
        PromotionStoreWrapper wrap = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), PromotionStoreWrapper.class);
        wrap = Objects.isNull(wrap) ? new PromotionStoreWrapper() : wrap;
        int qcIdType = wrap.getQcIdIsBlankType();
        wrap.setQcIdIsBlank(3 == qcIdType ? null : 1 == qcIdType);

        promotionStoreDao.findPage(wrap,pageInfo);
    }
}
