package com.wangxiaolu.promotion.domain.user.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author : liqiulin
 * @date : 2024-03-29 16
 * @describe :
 */
@TableName(value ="qince_employee")
@Data
public class QinCeEmployeeDO {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 勤策的员工唯一标识
     * 对应[QinCeEmployeeDTO.id]
     */
    @JsonProperty("id")
    private String qcId;

    /**
     * 来源第三方系统的员工唯一标识
     */
    @JsonProperty("emp_id")
    private String empId;

    /**
     * 员工登录帐号
     */
    @JsonProperty("emp_code")
    private String empCode;

    /**
     * 姓名
     */
    @JsonProperty("emp_name")
    private String empName;

    /**
     * 员工别名
     */
    @JsonProperty("alias_name")
    private String aliasName;

    /**
     * 人员编码
     */
    @JsonProperty("employee_code")
    private String employeeCode;

    /**
     * 最近登录时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("last_use_time")
    private String lastUseTime;

    /**
     * 员工性别。F：女性，M：男性
     */
    @JsonProperty("emp_sex")
    private String empSex;

    /**
     * 员工手机号码
     */
    @JsonProperty("emp_mobile")
    private String empMobile;

    /**
     * 员工手机地区码
     */
    @JsonProperty("mobile_district_code")
    private String mobileDistrictCode;

    /**
     * 固定电话
     */
    @JsonProperty("emp_tel")
    private String empTel;

    /**
     * 生日
     */
    @JsonProperty("emp_birthday")
    private String empBirthday;

    /**
     * QQ
     */
    @JsonProperty("emp_qq")
    private String empQq;

    /**
     * 微信
     */
    @JsonProperty("emp_weixin")
    private String empWeixin;

    /**
     * 身份证号码
     */
    @JsonProperty("emp_idcard")
    private String empIdcard;

    /**
     * 邮箱
     */
    @JsonProperty("emp_email")
    private String empEmail;

    /**
     * 地址
     */
    @JsonProperty("emp_addr")
    private String empAddr;

    /**
     * 来源第三方系统隶属部门
     */
    @JsonProperty("emp_org_id")
    private String empOrgId;

    /**
     * 隶属部门编码
     */
    @JsonProperty("emp_org_code")
    private String empOrgCode;

    /**
     * 勤策部门唯一标识
     * 对应QinCeDepartmentDO.qcId
     */
    @JsonProperty("waiqin365_org_id")
    private String waiqin365OrgId;

    /**
     * 来源第三方系统,员工上级唯一标识
     */
    @JsonProperty("emp_parent_id")
    private String empParentId;

    /**
     * 员工上级编码
     */
    @JsonProperty("parent_code")
    private String parentCode;

    /**
     * 勤策员工上级唯一标识
     */
    @JsonProperty("waiqin365_parent_id")
    private String waiqin365ParentId;

    /**
     * 是否机构领导。0：否，1：是，默认值0
     */
    @JsonProperty("emp_is_org_learder")
    private String empIsOrgLearder;

    /**
     * 员工账号状态。0：销户，1：正常，2：停用
     */
    @JsonProperty("emp_status")
    private String empStatus;

    /**
     * 手机卡绑定。0：不绑定，1：绑定
     */
    @JsonProperty("emp_imsi_binding")
    private String empImsiBinding;

    /**
     * 创建时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("create_time")
    private String createTime;

    /**
     * 修改时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("modify_time")
    private String modifyTime;

    /**
     * 勤策经销商唯一标识
     */
    @JsonProperty("dealer_id")
    private String dealerId;

    /**
     * 经销商中文名称
     */
    @JsonProperty("dealer_name")
    private String dealerName;

    /**
     * 常驻地省信息
     */
    @JsonProperty("emp_baseprovince")
    private String empBaseprovince;

    /**
     * 常驻地市信息
     */
    @JsonProperty("emp_basecity")
    private String empBasecity;

    /**
     * 勤策职务唯一标识
     */
    @JsonProperty("waiqin365_position_id")
    private String waiqin365PositionId;

    /**
     * 职务编码
     */
    @JsonProperty("emp_position_code")
    private String empPositionCode;

    /**
     * 职务名称
     */
    @JsonProperty("emp_position")
    private String empPosition;

    /**
     * 勤策岗位唯一标识
     */
    @JsonProperty("waiqin365_job_id")
    private String waiqin365JobId;

    /**
     * 岗位编码
     */
    @JsonProperty("emp_job_code")
    private String empJobCode;

    /**
     * 岗位名称
     */
    @JsonProperty("emp_job")
    private String empJob;

    /**
     * 来源企微员工唯一标识。只有企微同步过来的人员该字段才有值
     */
    @JsonProperty("emp_wechat_code")
    private String empWechatCode;

    /**
     * 入职时间。格式：yyyy-MM-dd
     */
    @JsonProperty("emp_enrollment_time")
    private String empEnrollmentTime;

    /**
     * 离职时间。格式：yyyy-MM-dd
     */
    @JsonProperty("emp_resignation_time")
    private String empResignationTime;

    /**
     * 手机认证，0为是，1为否
     */
    @JsonProperty("mobile_auth")
    private String mobileAuth;

    /**
     * 头像上传时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("face_time")
    private String faceTime;

    /**
     * 客户端类型。0:标准客户端（APP）、1:定制客户端（APP）、2:微信小程序、3:企业微信
     */
    @JsonProperty("terminal_type")
    private String terminalType;

    /**
     * 扩展字段列表
     */
//    @JsonProperty("exts")
//    private List<ExtsDTO> exts;

//    @NoArgsConstructor
//    @Data
//    public class ExtsDTO {
//        /**
//         * 扩展字段的字段名称
//         */
//        @JsonProperty("ext_column")
//        private String extColumn;
//
//        /**
//         * 扩展字段名称
//         */
//        @JsonProperty("ext_key")
//        private String extKey;
//
//        /**
//         * 	扩展字段值
//         */
//        @JsonProperty("ext_value")
//        private String extValue;
//    }
}
