package com.wangxiaolu.promotion.controller.user;

import com.wangxiaolu.promotion.pojo.user.vo.UserLoginParam;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.PromotionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-03-28 17
 * @describe :用户(销售)登录 暂未使用
 */

@RestController
@RequestMapping("/user/promotion")
public class PromotionLoginController {

    @Autowired
    PromotionService promotionService;

    @PostMapping("/login")
    public R login(@Validated @RequestBody UserLoginParam userLoginParam){
        promotionService.login(userLoginParam);
        return R.success();
    }
}
