package com.promotion.gateway.constant;

import lombok.Data;
import lombok.Getter;
import lombok.ToString;

/**
 * @author : liqiulin
 * @date : 2024-03-28 17
 * @describe : 返回状态编码
 */
@Getter
public enum RCode  implements StatusCode{
    /**
     * 程序统一编码（不分模块）
     * 1000+
     */
    SUCCESS(0, "请求成功"),
    FAILED(1001, "请求失败"),
    PARAM_ERROR(1002, "参数错误"),
    RESPONSE_PACK_ERROR(1003, "包装R失败"),
    SELECT_PARAMS_ERROR(1004, "查询条件错误"),
    REDIS_PUSH_DATA_NOT_EXIT(1005, "数据已过期或不存在，请重新上传；"),

    /**
     * 业务统一编码（不分模块）
     * 2000+
     */
    API_ERROR(2000, "业务异常"),
    API_DATA_ERROR(2001, "业务数据异常"),
    DATA_HAVE_ERROR(2002, "数据已存在，不可新增"),
    STATUS_UPDATE_ERROR(2003, "当前状态不可修改"),
    DATA_NOT_HAVE_ERROR(2004, "数据不存在"),
    DATA_TOO_MANY_ERROR(2005, "唯一数据存在多条"),
    READ_EXCEL_NULL_ERROR(2006, "表格为空或格式错误，请上传正确的文件"),
    READ_FILE_PATH_NULL_ERROR(2007, "文件读取失败，未获取到有效地址"),
    EXCEL_IS_XLS_OR_XLSX_FILE(2008, "请上传xls或xlsx表格文件"),
    NEED_PARAM_ERROR(2009, "请指定需要操作的数据"),

    /**
     * user
     * 3000+
     */
    LOGIN_PARAM_ERROR(3000, "登录信息错误"),
    ENROLL_PARAM_ERROR(3001, "注册信息错误"),
    PHONE_PARAM_ERROR(3002, "手机号异常"),
    USER_PHONE_UNIQUE_ERROR(3003, "手机号已注册"),
    LOGIN_USER_IS_NULL_ERROR(3004, "账号未注册"),
    CLOCK_DETAIL_ERROR(3005, "打卡信息错误"),
    CLOCK_DETAIL_TIME_ERROR(3006, "不在打卡时间范围内"),
    CHARGER_ID_ERROR(3007, "未找到战区或战区负责人"),
    NOT_LOGIN_ERROR(3008, "您尚未登录"),
    LOGIN_PASSWORD_ERROR(3009, "密码错误"),
    USER_REPETITIVE_CLOCK_MINUTE(3010, "%s分钟内请勿重复打卡"),
    IDEN_NUMBER_PARAM_ERROR(3011, "身份证号码错误"),
    WX_OPENID_PARAM_ERROR(3012, "微信登录错误，请退出小程序重新登录"),
    NOT_AVATAR_URL_PARAM_ERROR(3013, "请上传头像"),
    NOT_USER_NAME_PARAM_ERROR(3014, "姓名不可为空"),
    USER_WXOPENID_UNIQUE_ERROR(3015, "已使用其他手机号注册"),
    LOGIN_PHONE_PARAM_ERROR(3016, "手机号错误"),
    NOT_LOGIN_TIMEOUT_ERROR(3017, "您的登录已过期，请重新登录"),
    EMP_PRIVILEGE_ERROR(3018, "账号权限错误"),
    QC_USER_IS_NULL_ERROR(3019, "账号未在勤策中找到"),

    /**
     * promotion-模块异常
     * 4000+
     */
    PRO_NOT_QC_STORE_CLOCK_DISTANCE(4000,"打卡店铺距离偏差过大"),
    PRO_FAR_QC_STORE_CLOCK_DISTANCE(4001,"请在距离店铺100米内打卡"),
    SEND_BACK_REASON_NOT(4002,"请描述退回原因"),
    APPROVE_STATUS_REPETITION(4003,"审批状态不可重复"),
    MARKET_NUMBER_NOT_ERROR(4004,"数量不可为0"),
    PRODUCT_CLASS_NOT_ERROR(4005,"商品类型不可为空"),
    PRODUCT_CLASS_HAS_ERROR(4006,"商品类型已存在，不可新增"),
    PROMOTION_STORE_SAVE_ERROR(4007, "%s分钟内请勿重复提交"),
    PROMOTION_STORE_HAS_NAME(4008, "店铺名称重复，请修改"),
    UPDATE_CLOCK_PHOTO_TIME_LONG_ERROR(4009, "距离打卡已超过30分钟，照片不可更改"),
    PHOTO_IS_NULL_ERROR(4010, "打卡照片不可更改"),
    BAR_CODE_IS_ERROR(4011, "识别异常，请手动选择商品"),
    NOT_ADDRESS_ERROR(4012, "请刷新当前位置"),
    NOT_CLOCK_PHOTO_ERROR(4013, "请上传打卡图片"),
    NOT_CLOCK_ACTIVITY_PATTERN_ERROR(4014, "请选择活动模式"),
    NOT_CLOCK_STORE_ERROR(4015, "请选择店铺"),
    NOT_TGSH_PHOTO_ERROR(4016, "推广试吃照片数量过少"),
    NOT_TGHD_PHOTO_ERROR(4017, "推广互动照片数量过少"),
    NOT_TGCJ_PHOTO_ERROR(4018, "推广成交照片数量过少"),
    NOT_POS_PHOTO_ERROR(4019, "POS机凭证照片未上传"),
    NOT_MARKET_CELL_ERROR(4020, "商品出售记录未添加"),
    ACTIVITY_DATA_NOT_HAVE_ERROR(4021, "售卖记录不存在"),
    CLOCK_DATA_NOT_HAVE_ERROR(4022, "打卡记录不存在"),
    QINCE_STORE_CODE_ERROR(4023, "编码或店名错误，请与勤策保持一致"),
    QINCE_STORE_DEALER_ID_ERROR(4024, "经销商错误，请与勤策保持一致"),
    LOGIN_PHONE_COUNT_MUCH(4025, "获取手机号超过5次，请手动填写"),
    QINCE_STORE_DEALER_ERROR(4026, "所属经销商与修改前不一致，请重新选择"),
    ACTIVITY_PLAN_DATETIME_ERROR(4027, "时间错误，正确规则：上班时间<午休下班时间<午休上班时间<下班时间；"),


    /**
     * manage-模块异常
     * 5000+
     */
    ACTIVITY_PLAN_MONTH_HAS(5000,"本月活动计划已上传，请删除后再次上传"),
    ACTIVITY_PLAN_FILENAME_LONG(5001,"文件名过长，请少于20个字"),
    ACTIVITY_PLAN_CELL_NOT_NULL(5002,"第%s行有空值，请改正后再次提交；"),
    ACTIVITY_PLAN_TEM_ERROR(5003,"模板错误，请使用模板4.0；"),
    ACTIVITY_PLAN_REPETITION_ERROR(5004,"活动计划列表中，有日期重复的计划；"),
    ACTIVITY_PLAN_NOT_SELF_DELETE(5005,"以前计划/非归属本人计划，不可删除；"),
    ACTIVITY_PLAN_NOT_DELETE(5005,"不可修改今日及以前活动；"),
    ACTIVITY_PLAN_EXECUTE_ERROR(5006,"门店系统名称、经销商不可为空，请到勤策中修改；"),
    ACTIVITY_PLAN_EMPLOYEE_ERROR(5007,"计划归属人只能是城市经理；"),
    ACTIVITY_PLAN_IS_NULL(5008,"促销计划不存在；"),
    ACTIVITY_NOT_START(5009,"计划未开始；"),
    NEXT_MONTH_PLAN_CREATE_ERROR(5010, "只可创建次月计划；"),
    ACTIVITY_PLAN_EMPLOYEE_CREATE(5011, "只能创建自己的计划；"),
    FUNCTION_RESTRICT_ERROR(5012, "功能受限，请联系管理员；"),
    ACTIVITY_IS_START(5013,"计划已被促销员执行；"),
    ACTIVITY_ID_IS_START(5014,"「%s」号计划已被促销员执行；"),
    ACTIVITY_PLAN_ID_NOT_DELETE(5015,"「%s」号已超上班时间1小时，不可修改；"),
    ACTIVITY_PLAN_DATA_ERROR(5016,"活动日期必需是次日 至 月底"),


    /**
     * 腾讯云
     * 3500+
     */
    TENCENT_SMS_ERROR(3500, "短信发送失败"),
    TENCENT_SMS_REPETITION(3501, "短信已发送"),
    TENCENT_SMS_PHONE_CODE_ERROR(3502, "验证码错误"),
    ;


    private int code;
    private String msg;

    RCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}
