package com.promotion.gateway.data.impl;

import com.alibaba.fastjson.JSONObject;
import com.promotion.gateway.data.UserDataService;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-05-23 16
 * @describe : token - user互转
 */
@Slf4j
@Service
public class UserDataServiceImpl implements UserDataService {

    @Autowired
    RedisTemplate<String, String> redisTemplate;

    @Override
    public JSONObject getUserByToken(String token) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        String val = vo.get(token);
        return JSONObject.parseObject(val);
    }

    @Override
    public boolean hasKeyToken(String tokenKey) {
        Boolean wb = redisTemplate.hasKey(RedisKeys.UserKeys.WXL_LINK_TOKEN.getKey() + tokenKey);
        Boolean tb = redisTemplate.hasKey(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey() + tokenKey);
        return wb || tb;
    }
}
