package com.promotion.gateway.filter;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.promotion.gateway.data.UserDataService;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.filter.OrderedFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-05-23 16
 * @describe : 权限校验过滤器
 */
@Slf4j
@Component
public class AuthGlobalFilter implements GlobalFilter, Ordered {

    // 用户注册、用户登录、发送手机号验证码
    private final String whiteUrl = "login";

    @Autowired
    UserDataService userDataService;

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        // 当前访问的url
        String url = exchange.getRequest().getURI().getPath();

        // 1、判断url是否放行
        if (url.contains(whiteUrl)) {
            log.info("请求放行，URL：{}", url);
            return chain.filter(exchange);
        }

        String token = exchange.getRequest().getHeaders().getFirst("Authorization");
        // 2、未登录请求跳转登录
        if (StringUtils.isBlank(token)) {
            return loginError(exchange);
        }

        // 3、验证token'
        JSONObject userJson = userDataService.getUserByToken(token);
        if (Objects.isNull(userJson)) {
            log.info("token登录错误：{}", token);
            return loginError(exchange);
        }

        return chain.filter(exchange);
    }

    @Override
    public int getOrder() {
        return -1;
    }

    private Mono<Void> loginError(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.OK);
        response.getHeaders().add("Content-Type", "application/json;charset=UTF-8");
        R res = new R(RCode.NOT_LOGIN_ERROR);
        DataBuffer buffer = response.bufferFactory().wrap(new Gson().toJson(res).getBytes(StandardCharsets.UTF_8));
        return response.writeWith(Flux.just(buffer));
    }

}
