package com.promotion.gateway.filter.log;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class SysLog implements Serializable {
    private static final long serialVersionUID = -4173350480097599017L;

    private String targetServer;

    private String requestPath;

    private String requestMethod;

    private String schema;

    private String requestBody;

    private String responseData;

    private String ip;

    private Date requestTime;

    private Date responseTime;

    private Long executeTime;

    private String token;
}
