package com.promotion.gateway.filter.log;

import cn.hutool.core.date.DateUtil;

import java.io.Serializable;
import java.util.Date;

public class SysLog implements Serializable {
    private static final long serialVersionUID = -4173350480097599017L;

    private String targetServer;

    private String requestPath;

    private String requestMethod;

    private String schema;

    private String requestBody;

    private String responseData;

    private String ip;

    private Date requestTime;

    private Date responseTime;

    private Long executeTime;

    public String getTargetServer() {
        return targetServer;
    }

    public void setTargetServer(String targetServer) {
        this.targetServer = targetServer;
    }

    public String getRequestPath() {
        return requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getSchema() {
        return schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getResponseData() {
        return responseData;
    }

    public void setResponseData(String responseData) {
        this.responseData = responseData;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Date getRequestTime() {
        return requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }

    public Date getResponseTime() {
        return responseTime;
    }

    public void setResponseTime(Date responseTime) {
        this.responseTime = responseTime;
    }

    public Long getExecuteTime() {
        return executeTime;
    }

    public void setExecuteTime(Long executeTime) {
        this.executeTime = executeTime;
    }


    public String getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Override
    public String toString() {
        return "\n SysLog{"+
                " targetServer='" + targetServer + '\'' + ",\n" +
                " requestPath='" + requestPath + '\'' + ",\n" +
                " requestMethod='" + requestMethod + '\'' + ",\n" +
                " schema='" + schema + '\'' +  ",\n" +
                " requestBody='" + requestBody + '\'' + ",\n" +
                " responseData='" + responseData + '\'' + ",\n" +
                " ip='" + ip + '\'' + ",\n" +
                " requestTime=" + DateUtil.formatDateTime(requestTime) + ",\n" +
                " responseTime=" + DateUtil.formatDateTime(responseTime)+ ",\n" +
                " executeTime=" + executeTime +
                '}';
    }

    public static final class SysLogBuilder {
        private String targetServer;
        private String requestPath;
        private String requestMethod;
        private String schema;
        private String requestBody;
        private String responseData;
        private String ip;
        private Date requestTime;
        private Date responseTime;
        private Long executeTime;

        private SysLogBuilder() {
        }

        public static SysLogBuilder sysLog() {
            return new SysLogBuilder();
        }

        public SysLogBuilder targetServer(String targetServer) {
            this.targetServer = targetServer;
            return this;
        }

        public SysLogBuilder requestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public SysLogBuilder requestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }


        public SysLogBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public SysLogBuilder requestBody(String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public SysLogBuilder responseData(String responseData) {
            this.responseData = responseData;
            return this;
        }

        public SysLogBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public SysLogBuilder requestTime(Date requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public SysLogBuilder responseTime(Date responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public SysLogBuilder executeTime(Long executeTime) {
            this.executeTime = executeTime;
            return this;
        }

        public SysLog build() {
            SysLog sysLog = new SysLog();
            sysLog.setTargetServer(targetServer);
            sysLog.setRequestMethod(requestMethod);
            sysLog.setRequestPath(requestPath);
            sysLog.setSchema(schema);
            sysLog.setRequestBody(requestBody);
            sysLog.setResponseData(responseData);
            sysLog.setIp(ip);
            sysLog.setRequestTime(requestTime);
            sysLog.setResponseTime(responseTime);
            sysLog.setExecuteTime(executeTime);
            return sysLog;
        }
    }
}
