package com.promotion.gateway.data.impl;

import com.alibaba.fastjson.JSONObject;
import com.promotion.gateway.data.UserDataService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-05-23 16
 * @describe : token - user互转
 */
@Slf4j
@Service
public class UserDataServiceImpl implements UserDataService {

    @Autowired
    RedisTemplate<String, String> redisTemplate;

    @Override
    public JSONObject getUserByToken(String token) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        String val = vo.get(token);
        return JSONObject.parseObject(val);
    }
}
