package com.wangxiaolu.promotion.exception;

import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.result.basedata.StatusCode;
import lombok.Getter;

/**
 * @author : liqiulin
 * @date : 2024-03-28 19
 * @describe : 参数异常
 */
@Getter
public class ParamException extends RuntimeException{
    private int code;
    private String msg;

    public ParamException(StatusCode statusCode, String message) {
        super(message);
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
    }

    public ParamException(StatusCode statusCode) {
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
    }

    /**
     * 默认异常编码
     */
    public ParamException(String message) {
        super(message);
        this.code = RCode.LOGIN_PARAM_ERROR.getCode();
        this.msg = RCode.LOGIN_PARAM_ERROR.getMsg();
    }


}
