package com.wangxiaolu.promotion.exception;

import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.result.basedata.StatusCode;
import lombok.Getter;

/**
 * @author : liqiulin
 * @date : 2024-03-28 19
 * @describe : 业务流程异常
 */
@Getter
public class FlowException extends RuntimeException {
    private int code;
    private String msg;

    public FlowException(StatusCode statusCode, String message) {
        super(message);
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
    }

    /**
     * 默认异常编码
     */
    public FlowException(String message) {
        super(message);
        this.code = RCode.LOGIN_PARAM_ERROR.getCode();
        this.msg = RCode.LOGIN_PARAM_ERROR.getMsg();
    }

    /**
     * 默认异常编码
     */
    public FlowException(Integer code, String message) {
        this.code = code;
        this.msg = message;
    }


}
