package com.wangxiaolu.promotion.result.basedata;

import lombok.Getter;

/**
 * @author : liqiulin
 * @date : 2024-03-28 17
 * @describe : 返回状态编码
 */
@Getter
public enum RCode implements StatusCode {
    /**
     * 程序统一编码（不分模块）
     * 1000+
     */
    SUCCESS(0, "请求成功"),
    FAILED(1001, "请求失败"),
    PARAM_ERROR(1002, "参数错误"),
    RESPONSE_PACK_ERROR(1003, "包装R失败"),

    /**
     * 业务统一编码（不分模块）
     * 2000+
     */
    API_ERROR(2000, "业务异常"),
    API_DATA_ERROR(2001, "业务数据异常"),
    DATA_HAVE_ERROR(2002, "数据已存在，不可新增"),
    STATUS_UPDATE_ERROR(2003, "当前状态不可修改"),
    DATA_NOT_HAVE_ERROR(2004, "数据不存在"),
    DATA_TOO_MANY_ERROR(2005, "唯一数据存在多条"),

    /**
     * user
     * 3000+
     */
    LOGIN_PARAM_ERROR(3000, "登录信息错误"),
    ENROLL_PARAM_ERROR(3001, "注册信息错误"),
    PHONE_PARAM_ERROR(3002, "手机号异常"),
    USER_PHONE_IDENNUMBER_WXOPENID_UNIQUE_ERROR(3003, "个人信息已注册"),
    LOGIN_USER_IS_NULL_ERROR(3004, "账号未注册"),
    CLOCK_DETAIL_ERROR(3005, "打卡信息错误"),
    CLOCK_DETAIL_TIME_ERROR(3006, "不在打卡时间范围内"),
    CHARGER_ID_ERROR(3007, "未找到负责人"),
    NOT_LOGIN_ERROR(3008, "您尚未登录"),

    /**
     * promotion-模块异常
     * 4000+
     */
    PRO_NOT_QC_STORE_CLOCK_DISTANCE(4000,"打卡店铺距离偏差过大"),
    PRO_FAR_QC_STORE_CLOCK_DISTANCE(4001,"请在距离店铺100米内打卡"),



    /**
     * 腾讯云
     * 3500+
     */
    TENCENT_SMS_ERROR(3500, "短信发送失败"),
    TENCENT_SMS_REPETITION(3501, "短信已发送"),
    TENCENT_SMS_PHONE_CODE_ERROR(3502, "验证码错误"),
    ;


    private int code;
    private String msg;

    RCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }
}
