package com.wangxiaolu.promotion.result.advice;

import com.wangxiaolu.promotion.exception.APIException;
import com.wangxiaolu.promotion.exception.FlowException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.result.basedata.R;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import java.sql.SQLIntegrityConstraintViolationException;

/**
 * @author : liqiulin
 * @date : 2024-03-28 19
 * @describe : 统一异常处理
 */

@RestControllerAdvice
public class ControllerExceptionAdvice {

    @ExceptionHandler({ParamException.class})
    public R paramExceptionHandler(ParamException e) {
        return new R(e.getCode(), e.getMsg(), e.getMessage());
    }

    @ExceptionHandler({FlowException.class})
    public R flowExceptionHandler(FlowException e) {
        return new R(e.getCode(), e.getMsg(), e.getMessage());
    }

    @ExceptionHandler({APIException.class})
    public R apiExceptionHandler(APIException e) {
        return new R(e.getCode(), e.getMsg(), e.getMessage());
    }

    @ExceptionHandler({SQLIntegrityConstraintViolationException.class})
    public R dbConstraintViolationExceptionHandler(SQLIntegrityConstraintViolationException e) {
        RCode errorCode = RCode.USER_PHONE_IDENNUMBER_WXOPENID_UNIQUE_ERROR;
        String msg = errorCode.getMsg();
        String message = e.getMessage();
        if (message.contains("phone_unique")) {
            msg = "手机号已注册";
        } else if (message.contains("iden_num_unique")) {
            msg = "身份证已注册";
        } else if (message.contains("open_id_unique")) {
            msg = "微信号已注册";
        }
        return new R(errorCode.getCode(), msg, message);
    }

    @ExceptionHandler({MethodArgumentNotValidException.class})
    public R methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        String msg = e.getBindingResult().getFieldError().getDefaultMessage();
        return new R(RCode.PARAM_ERROR.getCode(), msg);
    }

    @ExceptionHandler({DataIntegrityViolationException.class})
    public R dataIntegrityViolationExceptionHandler(DataIntegrityViolationException e) {
        String msg = e.getMessage();
        if (msg.contains("java.sql.SQLIntegrityConstraintViolationException")){
            return dbConstraintViolationExceptionHandler(new SQLIntegrityConstraintViolationException(msg));
        }
        return new R(RCode.API_DATA_ERROR.getCode(), RCode.API_DATA_ERROR.getMsg(), msg);
    }

    @ExceptionHandler({TooManyResultsException.class})
    public R tooManyResultsExceptionHandler(TooManyResultsException e) {
        String msg = e.getMessage();
        return new R(RCode.DATA_TOO_MANY_ERROR.getCode(), msg);
    }

}
