package com.wangxiaolu.promotion.result.advice;

import com.wangxiaolu.promotion.exception.APIException;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.exception.FlowException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author : liqiulin
 * @date : 2024-03-28 19
 * @describe : 统一异常处理
 */

//@ControllerAdvice
@RestControllerAdvice
@Slf4j
public class ControllerExceptionAdvice {

    @ExceptionHandler({ParamException.class})
    public R paramExceptionHandler(ParamException e) {
        log.error("参数异常: {}", e);
        return new R(e.getCode(), e.getMsg());
    }

    @ExceptionHandler({IllegalArgumentException.class})
    public R paramExceptionHandler(IllegalArgumentException e) {
        log.error("参数异常2: {}", e);
        return new R(HttpStatus.BAD_REQUEST.value(), e.getMessage());
    }

    @ExceptionHandler({FlowException.class})
    public R flowExceptionHandler(FlowException e) {
        log.error("流量异常: {}", e);
        return new R(e.getCode(), e.getMsg());
    }

    @ExceptionHandler({APIException.class})
    public R apiExceptionHandler(APIException e) {
        log.error("API异常: {}", e);
        return new R(e.getCode(), e.getMsg());
    }

    @ExceptionHandler({DataException.class})
    public R dataExceptionHandler(DataException e) {
        log.error("数据异常: {}", e);
        return new R(e.getCode(), e.getMsg());
    }

    @ExceptionHandler({MethodArgumentNotValidException.class})
    public R methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        log.error("参数校验异常: {}", e);
        String msg = e.getBindingResult().getFieldError().getDefaultMessage();
        return new R(RCode.PARAM_ERROR.getCode(), msg);
    }

    @ExceptionHandler({DataIntegrityViolationException.class})
    public R dataIntegrityViolationExceptionHandler(DataIntegrityViolationException e) {
        log.error("数据库数据异常: {}", e);
        return new R(RCode.API_DATA_ERROR.getCode(), RCode.API_DATA_ERROR.getMsg());
    }

    @ExceptionHandler({TooManyResultsException.class})
    public R tooManyResultsExceptionHandler(TooManyResultsException e) {
        log.error("查询结果异常: {}", e);
        String msg = e.getMessage();
        return new R(RCode.DATA_TOO_MANY_ERROR.getCode(), msg);
    }

}
