package com.wangxiaolu.promotion.common.redis;

import lombok.AllArgsConstructor;
import lombok.Getter;

public interface RedisKeys {

    @AllArgsConstructor
    @Getter
    enum UserKeys {
        /**
         * 用户接收手机验证码
         */
        PHONE_VER_CODE("user:phone_code:phone_"),
        /**
         * 促销员小程序用户登录信息:token
         */
        TEMPORARY_TOKEN("user:login_token:temporary:"),
        ;

        String key;
    }


    @AllArgsConstructor
    @Getter
    enum TemporaryKeys {
        /**
         * 促销员暂存上报记录单元
         */
        TEMPORARY_ACTIVITY_MARKET_CELL("temporary:activity:market_cell:"),
        TEMPORARY_CLOCK_RECIRD("temporary:clock:"),
        TEMPORARY_SAVE_STORE_REPETITIVE("temporary:store_repetitive:"),
        TEMPORARY_SAVE_STORE_LINE_NAME("temporary:store_repetitive:line_map")
        ;

        String key;
    }


    @AllArgsConstructor
    @Getter
    enum ExportKeys {
        /**
         * 促销员暂存上报记录单元
         */
        ACTIVITY_REPORTED_PUSH_FEISHU_SHEET("export:activity_feishu:sheet_row_num:sheet-"),
        FEISHU_TENANT_TOKEN_ACTIVITY_ROBOT_1("export:feishu_tenant_token:activity_robot_1"),
        FEISHU_TENANT_TOKEN_ACTIVITY_ROBOT_2("export:feishu_tenant_token:activity_robot_2"),
        ;

        String key;
    }
}
