package com.wangxiaolu.promotion.common.util;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2025-02-07 10
 * @describe :
 */
public class BeanUtils extends org.springframework.beans.BeanUtils {


    public static <T> List<T> transitionDtos(Object sourceList, Class<?> beanClass) {
        if (sourceList == null) {
            return new ArrayList<>();
        }
        List<Object> sList = (List<Object>) sourceList;
        if (sList.isEmpty()) {
            return new ArrayList<>();
        }
        List<Object> btoList = new ArrayList<>(sList.size() * 2);
        try {
            for (Object so : sList) {
                Object bto = beanClass.newInstance();
                BeanUtils.copyProperties(so, bto);
                btoList.add(bto);
            }
            return (List<T>) btoList;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }


    public static <T> T transitionDto(Object source, Class<?> beanClass) {
        if (source == null) {
            return null;
        }
        try {
            Object bto = beanClass.newInstance();
            BeanUtils.copyProperties(source, bto);
            return (T)bto;
        } catch (Exception e) {
            return null;
        }
    }

}
