package com.wangxiaolu.promotion.exception;

import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.result.basedata.StatusCode;
import lombok.Getter;

/**
 * @author : liqiulin
 * @date : 2024-03-28 17
 * @describe : response包装R失败
 */
@Getter
public class DataException extends RuntimeException {
    private int code;
    private String msg;

    public DataException(StatusCode statusCode, String message) {
        super(message);
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
    }

    public DataException(StatusCode statusCode) {
        super(statusCode.getMsg());
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
    }

    /**
     * 默认异常编码
     */
    public DataException(String message) {
        super(message);
        this.code = RCode.API_ERROR.getCode();
        this.msg = RCode.API_ERROR.getMsg();
    }

    public DataException(StatusCode statusCode,Object... args) {
        this.code = statusCode.getCode();
        this.msg = String.format(statusCode.getMsg(),args);
    }


}
