package com.wangxiaolu.promotion.result.basedata;

import lombok.Data;

/**
 * @author : liqiulin
 * @date : 2024-03-28 17
 * @describe : 统一响应VO
 */
@Data
public class R {
    /**
     * 响应码
     * 非0失败
     */
    private int code;

    /**
     * 提示信息
     */
    private String msg;

    /**
     * 返回对象
     */
    private Object data;

    /**
     * 默认成功
     */
    public R(Object data) {
        this.code = RCode.SUCCESS.getCode();
        this.msg = RCode.SUCCESS.getMsg();
        this.data = data;
    }

    /**
     * 默认成功
     */
    public R() {
        this.code = RCode.SUCCESS.getCode();
        this.msg = RCode.SUCCESS.getMsg();
        this.data = null;
    }

    /**
     * 无数据返回
     */
    public R(StatusCode statusCode) {
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
        this.data = null;
    }

    /**
     * 手动配置code、msg
     */
    public R(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
        this.data = null;
    }

    /**
     * 指定状态
     */
    public R(StatusCode statusCode, Object data) {
        this.code = statusCode.getCode();
        this.msg = statusCode.getMsg();
        this.data = data;
    }

    /**
     * 手动设置
     */
    public R(int code, String msg, Object data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static R success(Object data) {
        return new R(data);
    }
    public static R success() {
        return new R();
    }
}
