package com.wangxiaolu.promotion.common.redis.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Component
public class RedisCache {

    @Autowired
    RedisTemplate<String, String> redisTemplate;

    /**
     * 保存一个值
     */
    public void add(String key, String val) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        vo.set(key, val);
    }

    /**
     * 保存一个值,设置过期时间(秒)
     */
    public void addToSeconds(String key, String val, long time) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        vo.set(key, val, time, TimeUnit.SECONDS);
    }

    /**
     * 保存一个值,设置过期时间(分钟)
     */
    public void addToMinute(String key, String val, long time) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        vo.set(key, val, time, TimeUnit.MINUTES);
    }

    /**
     * 保存一个值，并将val json化
     */
    public void addToJson(String key, Object val) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        vo.set(key, valToJson(val));
    }

    /**
     * 保存一个值，并将val json化，设置过期时间(分钟)
     */
    public void addToJsonToMinute(String key, Object val, long time) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        vo.set(key, valToJson(val), time, TimeUnit.MINUTES);
    }

    /**
     * 保存一个值，并将val json化，设置过期时间(天)
     */
    public void addToJsonToDays(String key, Object val, long days) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        vo.set(key, valToJson(val), days, TimeUnit.DAYS);
    }

    /**
     * 获取一个值
     */
    public String get(String key) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        return vo.get(key);
    }

    /**
     * 获取一个值，并将val json化
     */
    public JSONObject getToJson(String key) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        String val = vo.get(key);
        return JSONObject.parseObject(val);
    }

    /**
     * 获取一个值，并将val json array 化
     */
    public JSONArray getToJsonArray(String key) {
        ValueOperations<String, String> vo = redisTemplate.opsForValue();
        String val = vo.get(key);
        return JSONObject.parseArray(val);
    }

    public void putAllHash(String key, Map<Object,Object> values) {
        redisTemplate.opsForHash().putAll(key, values);
    }

    public String getHash(String key,String hashKey){
        Object o = redisTemplate.opsForHash().get(key, hashKey);
        return o.toString();
    }

    public Map<Object, Object> getAllHash(String key){
        Map<Object, Object> entries = redisTemplate.opsForHash().entries(key);
        return entries;
    }

    public Set<Object> getHashKeys(String key){
        Set<Object> keys = redisTemplate.opsForHash().keys(key);
        return keys;
    }

    /**
     * 获取一个值，并将val json化
     */
//    public JSONObject getUserJsonInfo(String authorization) {
//        JSONObject userDetail = getToJson(RedisKeys.UserKeys.TOKEN.getKey() + authorization);
//        return userDetail;
//    }
    public void removeKey(String key) {
        redisTemplate.delete(key);
    }



    private String valToJson(Object o) {
        return JSONObject.toJSONString(o);
    }

}
