#!/bin/bash

FLINK_VERSION=${2}

RUOSHUI_HOME=${RUOSHUI_HOME:-$(cd `dirname $0`; pwd)}
RUOSHUI_HOME=$(dirname "$RUOSHUI_HOME")
APP_HOME="${RUOSHUI_HOME}"

RUOSHUI_LOG_PATH="${APP_HOME}/logs/"
if [ ! -d "${RUOSHUI_LOG_PATH}" ]; then
  mkdir -p "${RUOSHUI_LOG_PATH}"
fi


JAR_NAME="ruoshui-datax-executor"


# Use FLINK_HOME:
CLASS_PATH="${APP_HOME}/lib/*:${APP_HOME}/config"
PID_FILE="executor.pid"

# Log configuration file path
LOG_CONFIG=${APP_HOME}/config/logback.xml
# JVM options G1GC and OOM dump ; Note: Do not set the DisableExplicitGC parameter. Because there is a call to System. gc() in the code.
GC_OPT="-XX:+UseG1GC -XX:+PrintGCDetails -XX:+PrintGCDateStamps -XX:+PrintHeapAtGC -XX:+PrintGCCause -Xloggc:${APP_HOME}/logs/gc-%t.log -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=10 -XX:GCLogFileSize=20M"
# OOM dump path
OOM_OPT="-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=${APP_HOME}/logs/heapdump.hprof"
# JVM parameters and log path
PARAMS_OPT="-Druoshui.logs.path=${RUOSHUI_LOG_PATH} -Ddruid.mysql.usePingMethod=false -Dlog4j2.isThreadContextMapInheritable=true"
# JAR parameters
JAR_PARAMS_OPT="--logging.config=${LOG_CONFIG}"
# JMX path
JMX="-javaagent:$APP_HOME/lib/jmx_prometheus_javaagent-0.20.0.jar=10087:$APP_HOME/config/jmx/jmx_exporter_config.yaml"
#JVM OPTS
JVM_OPTS="-Xms512M -Xmx2048M -XX:PermSize=512M -XX:MaxPermSize=1024M"

# Check whether the pid path exists
PID_PATH="${APP_HOME}/run"

if [ -d "${PID_PATH}" ];then
    echo "${PID_PATH} is already exist." >> /dev/null
else
    mkdir -p  "${PID_PATH}"
fi

# Check whether the pid file exists
if [ -f "${PID_PATH}/${PID_FILE}" ];then
    echo "${PID_PATH}/${PID_FILE} is already exist." >> /dev/null
else
    touch "${PID_PATH}"/${PID_FILE}
fi

tips() {
  echo ""
  echo "WARNING!!!......Tips, please use command: sh auto.sh [start|startOnPending|startWithJmx|stop|restart|restartWithJmx|status].   For example: sh auto.sh start  "
  echo ""
  exit 1
}

updatePid() {
  pid=$(ps -ef | grep [r]uoshui-datax-executor  | awk '{print $2}' | head -1)
  echo $pid >"${PID_PATH}"/${PID_FILE}
}

start() {
  updatePid
  if [ -z "$pid" ]; then
    nohup java -jar ${APP_HOME}/executor/ruoshui-datax-executor.jar --spring.config.location=${APP_HOME}"/executor/config/" --spring.config.name=application  > /dev/null 2>&1 &
    echo $! >"${PID_PATH}"/${PID_FILE}
    echo "........................................Start RuoShui Successfully........................................"
  else
    echo "RuoShui pid $pid is in ${PID_PATH}/${PID_FILE}, Please stop first !!!"
  fi
}

startOnPending() {
  updatePid
  if [ -z "$pid" ]; then
    java -jar "${APP_HOME}/executor/ruoshui-datax-executor.jar" --spring.config.location="${APP_HOME}/executor/config/" --spring.config.name=application
    echo java -jar ${APP_HOME}/executor/ruoshui-datax-executor.jar --spring.config.location=${APP_HOME}"/executor/config/" --spring.config.name=application
    echo "........................................Start RuoShui Successfully........................................"
  else
    echo "RuoShui pid $pid is in ${PID_PATH}/${PID_FILE}, Please stop first !!!"
  fi
}

startWithJmx() {
  assertIsInputVersion
  updatePid
  if [ -z "$pid" ]; then
    nohup java -jar ${APP_HOME}/executor/ruoshui-datax-executor.jar --spring.config.location=${APP_HOME}"/executor/config/" --spring.config.name=application   > /dev/null 2>&1 &
#    echo $! >"${PID_PATH}"/${PID_FILE}
    updatePid
    echo "........................................Start RuoShui with Jmx Successfully.....................................
    ..."
  else
    echo "RuoShui pid $pid is in ${PID_PATH}/${PID_FILE}, Please stop first !!!"
  fi
}

stop() {
  updatePid
  pid=$(cat "${PID_PATH}"/${PID_FILE})
  if [ -z $pid ]; then
    echo "RuoShui pid is not exist in ${PID_PATH}/${PID_FILE} ,skip stop."
  else
    kill -9 $pid
    sleep 1
    echo "........................................Stop RuoShui Successfully....................................."
    rm -f "${PID_PATH}"/${PID_FILE}
  fi
}

status() {
  updatePid
  if [ -z $pid ]; then
    echo ""
    echo "Service ${JAR_NAME} is not running!"
    echo ""
    exit 1
  else
    echo ""
    echo "Service ${JAR_NAME} is running. It's pid=${pid}"
    echo ""
  fi
}

restart() {
  echo ""
  assertIsInputVersion
  stop
  start
  echo "........................................Restart Successfully........................................"
}

restartWithJmx() {
  echo ""
  assertIsInputVersion
  stop
  startWithJmx
  echo "........................................Restart with Jmx Successfully........................................"
}

case "$1" in
"start")
  start
  ;;
"startOnPending")
  startOnPending
  ;;
"startWithJmx")
  startWithJmx
  ;;
"stop")
  stop
  ;;
"status")
  status
  ;;
"restart")
  restart
  ;;
"restartWithJmx")
  restartWithJmx
  ;;
*)
  tips
  ;;
esac
