@echo off
chcp 65001

set AppName=RuoShuiApplication
set AppPath=admin/
set JAVA_OPTS=-cp "../lib/*;../config" com.ruoshui.RuoShuiApplication

echo.
echo [1] 启动 %AppName%
echo [2] 停止 %AppName%
echo [3] 重启 %AppName%
echo [4] 状态 %AppName%
echo [5] 退出
echo.

echo 请输入选项:
set /p choice=
if "%choice%"=="1" goto start
if "%choice%"=="2" goto stop
if "%choice%"=="3" goto restart
if "%choice%"=="4" goto status
if "%choice%"=="5" exit
pause

:start
for /f "tokens=1" %%i in ('jps -l ^| findstr /i %AppName%') do set pid=%%i
if "%pid%" NEQ "" (
    echo * %AppName% 已经在运行
    PAUSE
    goto eof
)

echo * 启动 %AppName%...
set JAVA_EXEC_CMD=start javaw %JAVA_OPTS%
echo %JAVA_EXEC_CMD%
%JAVA_EXEC_CMD%
pause
goto eof

:stop
for /f "tokens=1" %%i in ('jps -l ^| findstr /i %AppName%') do set pid=%%i
if "%pid%"=="" (
    echo * %AppName% 尚未运行
    PAUSE
    goto eof
)

echo * 停止 %AppName%...
taskkill /F /PID %pid%
goto eof

:restart
call :stop
call :start
goto eof

:status
echo Checking status...
for /f "tokens=1" %%i in ('jps -l ^| findstr /i %AppName%') do set pid=%%i
echo PID: %pid%
if "%pid%" NEQ "" (
    echo * %AppName% 正在运行中，进程 ID 为 %pid%
    goto eof
) else (
    echo * %AppName% 尚未运行
    goto eof
)

:eof
pause