/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzW4t;
import com.aspose.words.internal.zzWay;
import com.aspose.words.internal.zzXcX;
import com.aspose.words.internal.zzXrY;
import com.aspose.words.internal.zzY4Y;
import com.aspose.words.internal.zzZEG;
import com.aspose.words.internal.zzZMc;
import com.aspose.words.internal.zzZZb;
import com.aspose.words.internal.zzzX;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzYzN
extends CertPathBuilderSpi {
    private final zzY4Y zzxn;
    private zzZZb zzsb;

    zzYzN(zzY4Y zzY4Y2) {
        this.zzxn = zzY4Y2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzXcX pkixParams;
        if (params instanceof zzXcX) {
            pkixParams = (zzXcX)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzXcX.zzZ35((PKIXBuilderParameters)params).zzW4E();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzXcX.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzzX zzzX2 = pkixParams.zzZAn().zzWKa();
        try {
            collection = zzZMc.zzZ35(zzzX2, pkixParams.zzZAn().zzXNp());
            collection.addAll(zzZMc.zzZ35(zzzX2, pkixParams.zzZAn().zzZnY()));
        }
        catch (zzZZb zzZZb2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzZZb2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzZ35(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzsb != null) {
            throw new CertPathBuilderException(this.zzsb.getMessage(), this.zzsb.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzZ35(X509Certificate x509Certificate, zzXcX zzXcX2, List list) throws CertPathBuilderException {
        zzXrY zzXrY2;
        zzZEG zzZEG2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzXcX2.zzWOx().contains(x509Certificate)) {
            return null;
        }
        if (zzXcX2.zzX2W() != -1 && list.size() - 1 > zzXcX2.zzX2W()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZEG2 = new zzZEG(this.zzxn);
            zzXrY2 = new zzXrY(this.zzxn);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZMc.zzZ35(x509Certificate, zzXcX2.zzZAn().zzQp(), zzXcX2.zzZAn().zzYNQ()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZEG2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzZZb("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzXrY2.engineValidate(certPath, zzXcX2);
                }
                catch (Exception exception) {
                    throw new zzZZb("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzW4t> arrayList = new ArrayList<zzW4t>();
            arrayList.addAll(zzXcX2.zzZAn().zzXNp());
            try {
                arrayList.addAll(zzZMc.zzZ35(x509Certificate.getExtensionValue(zzWay.zzWiT.getId()), zzXcX2.zzZAn().zzXC()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzZZb("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZMc.zzZ35(x509Certificate, zzXcX2.zzZAn().zzZnY(), arrayList));
            }
            catch (zzZZb zzZZb2) {
                throw new zzZZb("Cannot find issuer certificate for certificate in certification path.", zzZZb2);
            }
            if (hashSet.isEmpty()) {
                throw new zzZZb("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzZ35(x509Certificate2, zzXcX2, list);
            }
        }
        catch (zzZZb zzZZb3) {
            this.zzsb = zzZZb3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

