/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzW3i;
import com.aspose.words.internal.zzW7G;
import com.aspose.words.internal.zzWJ5;
import com.aspose.words.internal.zzWND;
import com.aspose.words.internal.zzWc6;
import com.aspose.words.internal.zzWh5;
import com.aspose.words.internal.zzWwK;
import com.aspose.words.internal.zzXkP;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.internal.zzYad;
import com.aspose.words.internal.zzZTw;
import com.aspose.words.internal.zzox;
import com.aspose.words.zz1i;
import com.aspose.words.zzE3;
import com.aspose.words.zzVP6;
import com.aspose.words.zzVVR;
import com.aspose.words.zzVWK;
import com.aspose.words.zzWJa;
import com.aspose.words.zzWY7;
import com.aspose.words.zzWp2;
import com.aspose.words.zzWpL;
import com.aspose.words.zzZr0;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzZ35(zzWwK zzWwK2, zzWwK zzWwK3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzXwP.zzXEJ((Object)zzWwK2, "srcStream");
        zzXwP.zzXEJ((Object)zzWwK3, "dstStream");
        zzXwP.zzXEJ((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzXEJ(zzWwK2, zzWwK3, certificateHolder, signOptions);
        zzWwK3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzZ35(zzWwK.zzXEJ(srcStream), (zzWwK)zzWwK.zzWsb(dstStream), certHolder, signOptions);
    }

    private static void zzXEJ(zzWwK zzWwK2, zzWwK zzWwK3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWsb(digitalSignature);
        }
        if (zz1i.zzWDI(zzWwK2)) {
            DigitalSignatureUtil.zzZ35(zzWwK2, zzWwK3, digitalSignature, true);
            return;
        }
        zz1i zz1i2 = new zz1i();
        zzWwK zzWwK4 = zzWwK2;
        zz1i zz1i3 = zz1i2;
        FileFormatInfo fileFormatInfo = zz1i2.zzXEJ(zzWwK4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWc6 zzWc62 = new zzWc6(zzWwK2);
                int n = fileFormatInfo.zzUv() == 1 ? 1 : 2;
                zzVVR.zzZ35(zzWc62, digitalSignature, n);
                zzWwK3.zzXYP(0L);
                zzWc62.zzYiy(zzWwK3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzZ35(fileFormatInfo.zzWhq(), zzWwK3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzZ35(zzWwK2, zzWwK3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzZ35(zzWwK2, zzWwK3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzXwP.zzZ35(srcFileName, "srcFileName");
        zzXwP.zzZ35(dstFileName, "dstFileName");
        try (zzW3i zzW3i2 = zzXwP.zzXEJ(srcFileName, 3, 1);){
            try (zzW3i zzW3i3 = zzXwP.zzXEJ(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZ35((zzWwK)zzW3i2, (zzWwK)zzW3i3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzWJ5 zzWJ52 = zzWwK.zzWsb(dstStream);
        zzWwK zzWwK2 = zzWwK.zzXEJ(srcStream);
        DigitalSignatureUtil.zzZ35(zzWwK2, (zzWwK)zzWJ52, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzW3i zzW3i2 = zzXwP.zzXEJ(srcFileName, 3, 1);){
            try (zzW3i zzW3i3 = zzXwP.zzXEJ(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzVZv(zzW3i2, zzW3i3);
            }
            return;
        }
    }

    private static void zzVZv(zzWwK zzWwK2, zzWwK zzWwK3) throws Exception {
        zz1i zz1i2 = new zz1i();
        zzWwK zzWwK4 = zzWwK2;
        zz1i zz1i3 = zz1i2;
        FileFormatInfo fileFormatInfo = zz1i2.zzXEJ(zzWwK4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzWc6 zzWc62 = new zzWc6(zzWwK2);
                zzWc62.zzXg3().zzWXU("_xmlsignatures");
                zzWc62.zzXg3().zzWXU("_signatures");
                zzWwK3.zzXBR(0L);
                zzWc62.zzYiy(zzWwK3);
                zzWwK zzWwK5 = zzWwK3;
                zzWwK5.zzXYP(zzWwK5.zz93());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYad zzYad2 = new zzYad(zzWwK2);
                zzW7G zzW7G2 = zzYad2.zzZ35(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzW7G2 != null) {
                    for (zzXkP zzXkP2 : zzW7G2.zzWe8()) {
                        String string = zzW7G2.zzZ35(zzXkP2);
                        zzYad2.zzZl9().remove(string);
                    }
                    zzYad2.zzZl9().remove(zzW7G2.getName());
                    zzXkP zzXkP3 = zzYad2.zzWe8().zzYxK("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYad2.zzWe8().remove(zzXkP3.getId());
                    zzYad2.zztz();
                }
                zzWwK3.zzXBR(0L);
                zzYad2.zzYiy(zzWwK3);
                zzWwK zzWwK6 = zzWwK3;
                zzWwK6.zzXYP(zzWwK6.zz93());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzVZv(zzWwK.zzXEJ(srcStream), zzWwK.zzWsb(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzW3i zzW3i2 = zzXwP.zzXEJ(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzW9J(zzW3i2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzW9J(zzWwK zzWwK2) throws Exception {
        if (zz1i.zzWDI(zzWwK2)) {
            return DigitalSignatureUtil.zzoP(zzWwK2);
        }
        zz1i zz1i2 = new zz1i();
        zzWwK zzWwK3 = zzWwK2;
        zz1i zz1i3 = zz1i2;
        FileFormatInfo fileFormatInfo = zz1i2.zzXEJ(zzWwK3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzWwK2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzW9J(zzWwK.zzXEJ(stream));
    }

    static zzox zzZ35(zzWc6 zzWc62, String string) throws Exception {
        zzWpL zzWpL2 = new zzWpL(zzWc62);
        if (zzWpL2.zzXWg()) {
            zzox zzox2 = zzWpL2.zzYzv(string);
            return zzox2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZjq(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzZTw.zzXEJ("Unexpected digest algorithm: {0}.", n));
    }

    static String zzBk(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzZjq(n);
    }

    private static void zzZ35(zzWwK zzWwK2, zzWwK zzWwK3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYad zzYad2 = new zzYad(zzWwK2);
        zzE3 zzE32 = bl ? new zzZr0(zzYad2) : new zzWp2(zzYad2);
        zzE32.zzXEJ(digitalSignature);
        zzWwK3.zzXYP(0L);
        zzYad2.zzYiy(zzWwK3);
    }

    private static void zzZ35(zzWwK zzWwK2, zzWwK zzWwK3, DigitalSignature digitalSignature) throws Exception {
        zzVWK zzVWK2 = new zzVWK(zzWwK2);
        zzWY7 zzWY72 = new zzWY7(zzVWK2);
        zzWY72.zzXEJ(digitalSignature);
        zzWwK3.zzXYP(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzWwK zzWwK4 = zzWwK3;
        zzVWK zzVWK3 = zzVWK2;
        zzVWK3.zzZ35(zzWwK4, string, null);
    }

    private static void zzZ35(zzWc6 zzWc62, zzWwK zzWwK2, DigitalSignature digitalSignature, String string) throws Exception {
        zzox zzox2 = DigitalSignatureUtil.zzZ35(zzWc62, string);
        zzox zzox3 = new zzox();
        DigitalSignatureUtil.zzZ35((zzWwK)zzox2, (zzWwK)zzox3, digitalSignature, false);
        zzWc6 zzWc63 = zzWpL.zzWsb(zzox3, string);
        zzWc63.zzYiy(zzWwK2);
    }

    private static DigitalSignatureCollection zzoP(zzWwK zzWwK2) throws Exception {
        zzWwK2.zzXBR(0L);
        zzYad zzYad2 = new zzYad(zzWwK2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzW7G zzW7G2 = zzYad2.zzZ35(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzW7G2 != null) {
            for (zzXkP zzXkP2 : zzW7G2.zzWe8()) {
                String string = zzW7G2.zzZ35(zzXkP2);
                zzW7G zzW7G3 = zzYad2.zzX3y(string);
                zzW7G zzW7G4 = zzYad2.zzZ35(zzW7G3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzWh5 zzWh52 = zzWND.zzc(zzW7G4.zzVR1().zzXex());
                zzWJa.zzZ35(zzW7G3.zzYbK(), zzWh52, new zzVP6(zzYad2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

