/*
 * Decompiled with CFR 0.152.
 */
package com.lark.cn.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SqlCommandParser {
    private static final Function<String[], Optional<String[]>> NO_OPERANDS = operands -> Optional.of(new String[0]);
    private static final Function<String[], Optional<String[]>> SINGLE_OPERAND = operands -> Optional.of(new String[]{operands[0]});
    private static final int DEFAULT_PATTERN_FLAGS = 34;

    private SqlCommandParser() {
    }

    public static List<SqlCommandCall> parse(List<String> lines) {
        ArrayList<SqlCommandCall> calls = new ArrayList<SqlCommandCall>();
        StringBuilder stmt = new StringBuilder();
        for (String line : lines) {
            if (line.trim().isEmpty() || line.startsWith("--")) continue;
            stmt.append("\n").append(line);
            if (!line.trim().endsWith(";")) continue;
            Optional<SqlCommandCall> optionalCall = SqlCommandParser.parse(stmt.toString());
            if (!optionalCall.isPresent()) {
                throw new RuntimeException("Unsupported command '" + stmt.toString() + "'");
            }
            calls.add(optionalCall.get());
            stmt.setLength(0);
        }
        return calls;
    }

    public static Optional<SqlCommandCall> parse(String stmt) {
        if ((stmt = stmt.trim()).endsWith(";")) {
            stmt = stmt.substring(0, stmt.length() - 1).trim();
        }
        for (SqlCommand cmd : SqlCommand.values()) {
            Matcher matcher = cmd.pattern.matcher(stmt);
            if (!matcher.matches()) continue;
            String[] groups = new String[matcher.groupCount()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = matcher.group(i + 1);
            }
            return cmd.operandConverter.apply(groups).map(operands -> new SqlCommandCall(cmd, (String[])operands));
        }
        return Optional.empty();
    }

    static /* synthetic */ Function access$000() {
        return SINGLE_OPERAND;
    }

    public static class SqlCommandCall {
        public final SqlCommand command;
        public final String[] operands;

        public SqlCommandCall(SqlCommand command, String[] operands) {
            this.command = command;
            this.operands = operands;
        }

        public SqlCommandCall(SqlCommand command) {
            this(command, new String[0]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SqlCommandCall that = (SqlCommandCall)o;
            return this.command == that.command && Arrays.equals(this.operands, that.operands);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.command});
            result = 31 * result + Arrays.hashCode(this.operands);
            return result;
        }

        public String toString() {
            return (Object)((Object)this.command) + "(" + Arrays.toString(this.operands) + ")";
        }
    }

    public static enum SqlCommand {
        SELECT("(^SELECT\\s.*)", SqlCommandParser.access$000()),
        INSERT_INTO("(INSERT\\s+INTO.*)", SqlCommandParser.access$000()),
        CREATE_TABLE("(CREATE\\s+TABLE.*)", SqlCommandParser.access$000()),
        SET("SET(\\s+(\\S+)\\s*=(.*))?", operands -> {
            if (((String[])operands).length < 3) {
                return Optional.empty();
            }
            if (operands[0] == null) {
                return Optional.of(new String[0]);
            }
            return Optional.of(new String[]{operands[1], operands[2]});
        });

        public final Pattern pattern;
        public final Function<String[], Optional<String[]>> operandConverter;

        private SqlCommand(String matchingRegex, Function<String[], Optional<String[]>> operandConverter) {
            this.pattern = Pattern.compile(matchingRegex, 34);
            this.operandConverter = operandConverter;
        }

        public String toString() {
            return super.toString().replace('_', ' ');
        }

        public boolean hasOperands() {
            return this.operandConverter != NO_OPERANDS;
        }
    }
}

