/*
 * Decompiled with CFR 0.152.
 */
package com.lark.cn.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SourceGenerator {
    private static final long SPEED = 1000L;

    public static void main(String[] args) {
        long speed = 1000L;
        if (args.length > 0) {
            speed = Long.valueOf(args[0]);
        }
        long delay = 1000000L / speed;
        try (InputStream inputStream = SourceGenerator.class.getClassLoader().getResourceAsStream("user_behavior.log");){
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            long start = System.nanoTime();
            while (reader.ready()) {
                String line = reader.readLine();
                System.out.println(line);
                long end = System.nanoTime();
                long diff = end - start;
                while (diff < delay * 1000L) {
                    Thread.sleep(1L);
                    end = System.nanoTime();
                    diff = end - start;
                }
                start = end;
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

