/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.zzVZs;
import com.aspose.words.zzWHr;
import com.aspose.words.zzXis;
import com.aspose.words.zzXwc;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzXis,
Iterable<T> {
    private Node zzYGj;
    private CompositeNode zzY0M;
    private DocumentBase zzYjK;
    private boolean zzZ1k;
    private int zzWmx;
    private int zzYqu;
    private Node zz0k;
    private int zzXYP;
    private zzVZs zzdn;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzXwc(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzXwc(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzVZs matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzY0M = container;
        this.zzYjK = container.getDocument();
        this.zzdn = matcher;
        this.zzZ1k = isDeep;
        this.zzZDW();
    }

    public Node get(int index) {
        try {
            this.zzYJl();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYqu == index) {
                return this.zz0k;
            }
            int n = index - this.zzYqu;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzXYI(nodeCollection.zz0k, n);
            if (node != null) {
                this.zzYqu = index;
                this.zz0k = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZ1k) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzY0M.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZ1k) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzY0M.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzW3T();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzWHr(this);
    }

    final <TNode extends Node> zzWHr<TNode> zzmW() {
        return new zzWHr(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzW3T() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzXwP.zzZ35(arrayList, node);
        }
        return arrayList;
    }

    private Node zzXYI(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZxS(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzYyM(curNode, true);
    }

    private Node zzYyM(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzYGj = node;
        do {
            node2 = this.zzYGj;
            Node node3 = this.zzZ1k ? this.zzZ35(true, this.zzYGj) : (this.zzYGj = this.zzdn.zzWlE() ? this.zzWsb(true, this.zzYGj) : this.zzXEJ(true, this.zzYGj));
        } while (this.zzYGj != null && !this.zzdn.zzWOk(this.zzYGj));
        return node2;
    }

    private Node zzZxS(Node node, boolean bl) throws Exception {
        while ((this.zzZ1k ? this.zzZ35(bl, node) : (node = this.zzdn.zzWlE() ? this.zzWsb(bl, node) : this.zzXEJ(bl, node))) != null && !this.zzdn.zzWOk(node)) {
        }
        return node;
    }

    private Node zzZ35(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzY0M);
        }
        return node.previousPreOrder(this.zzY0M);
    }

    private Node zzXEJ(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzY0M) {
                return this.zzY0M.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzY0M) {
            return this.zzY0M.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzWsb(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzY0M ? this.zzY0M.zzWyI() : node.zzZUH();
        } else {
            Node node3 = node2 = node == this.zzY0M ? this.zzY0M.zzWFV() : node.zzZ1y();
        }
        if (node2 == this.zzY0M.getNextSibling() || node2 == this.zzY0M.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzYJl() {
        if (this.zzWmx != this.zzWd4()) {
            this.zzZDW();
        }
    }

    private void zzZDW() {
        this.zzWmx = this.zzWd4();
        this.zzYqu = -1;
        this.zz0k = this.zzY0M;
        this.zzXYP = -1;
    }

    private int zzWd4() {
        if (this.zzYjK != null) {
            return this.zzYjK.zzYCM();
        }
        return 0;
    }

    public int getCount() {
        this.zzYJl();
        if (this.zzXYP == -1) {
            this.zzXYP = zzWHr.zzZ35(this);
        }
        return this.zzXYP;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYGj;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzY0M;
    }
}

