/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.zz47;
import com.aspose.words.zz6R;
import com.aspose.words.zzWHr;
import com.aspose.words.zzWdP;
import com.aspose.words.zzXis;
import com.aspose.words.zzYa8;
import com.aspose.words.zzf8;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzXis,
Iterable<T> {
    private Node zzWAo;
    private Node zzXy2;
    private Node zzYGj;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzWAl() {
        return this.zzWyI() != null;
    }

    final boolean zzZqX() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzmT() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzYa8) {
                return true;
            }
            CompositeNode compositeNode = zzXwP.zzZ35((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzmT()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzWAo;
    }

    public Node getLastChild() {
        return this.zzXy2;
    }

    final Node zzWyI() {
        return zz6R.zzZOv(this.getFirstChild(), false);
    }

    final Node zzWFV() {
        return zz6R.zzYQG(this.getLastChild(), false);
    }

    final CompositeNode zzYyq() {
        return (CompositeNode)zz6R.zzZOv(this.getFirstChild(), true);
    }

    final CompositeNode zzWQB() {
        return (CompositeNode)zz6R.zzYQG(this.getLastChild(), true);
    }

    final Node zzZPl() {
        Node node;
        for (node = this.getFirstChild(); node != null && zz6R.zzZAj(node); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWjG() {
        Node node;
        for (node = this.getLastChild(); node != null && zz6R.zzZAj(node); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzZ35(boolean bl, zzf8 zzf82) {
        CompositeNode compositeNode = (CompositeNode)super.zzZ35(bl, zzf82);
        ((CompositeNode)super.zzZ35(bl, zzf82)).zzXy2 = null;
        compositeNode.zzWAo = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzZxS(node.zzZ35(true, zzf82));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzX21(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzX21(StringBuilder stringBuilder) {
        this.zzVQd(stringBuilder);
        zzXwP.zzXEJ(stringBuilder, this.zzXJZ());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzXEJ(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zz6R.zzZjZ(nodeType);
            Node node2 = node = bl ? this.zzWyI() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZUH() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zz47.zzWsb(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zz47.zzWXJ(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzWHr(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzZ35(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzZ35(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzZ35(oldChild, this, null, 1);
        if (documentBase.zzZ3d() && zz6R.zzW9J(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzZ35(nodeChangingArgs);
        }
        Node node = this.zzXee(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzXEJ(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzWdP.zzZAj(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzZxS(Node node) {
        node.getParentNode();
        if (this.zzXy2 == null) {
            node.zzXaF(null);
            node.zzYkb(null);
            this.zzWAo = node;
        } else {
            node.zzXaF(this.zzXy2);
            node.zzYkb(null);
            this.zzXy2.zzYkb(node);
        }
        this.zzXy2 = node;
        node.zzVTu(this);
        return node;
    }

    final void zzZ35(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzXEJ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzXEJ(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zz6R.zzZAj(node2)) continue;
            if (zz6R.zzVZv(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzXJZ().length();
    }

    String zzXJZ() {
        return "";
    }

    final String zzIE() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzVQd(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzVQd(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzX21(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzZ35(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzXEJ(visitor));
    }

    abstract int zzZ35(DocumentVisitor var1) throws Exception;

    abstract int zzXEJ(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzVQd(Node var1);

    final Node zzZ35(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZnn(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 35 && !this.zzVQd(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
            if (!node.zzX4T()) {
                node.getParentNode().zzXee(node);
            }
        }
        if ((nodeChangingArgs = documentBase.zzZ35(node, null, this, 0)) != null) {
            documentBase.zzZ35(nodeChangingArgs);
        }
        if (this.zzXy2 == null) {
            node.zzXaF(null);
            node.zzYkb(null);
            this.zzWAo = node;
            this.zzXy2 = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzXEJ(node, node2);
            } else {
                this.zzWsb(node, this.zzWAo);
            }
        } else if (node2 != null) {
            this.zzWsb(node, node2);
        } else {
            this.zzXEJ(node, this.zzXy2);
        }
        node.zzVTu(this);
        if (nodeChangingArgs != null) {
            documentBase.zzXEJ(nodeChangingArgs);
        }
        if (documentBase.zzZ3d()) {
            zz6R.zzuf(node);
        }
        return node;
    }

    private void zzXEJ(Node node, Node node2) {
        Node node3 = node2.zzY4H();
        node.zzXaF(node2);
        node.zzYkb(node3);
        node2.zzYkb(node);
        if (node3 == null) {
            this.zzXy2 = node;
            return;
        }
        node3.zzXaF(node);
    }

    private void zzWsb(Node node, Node node2) {
        Node node3 = node2.zzYRC();
        node.zzXaF(node3);
        node.zzYkb(node2);
        node2.zzXaF(node);
        if (node3 == null) {
            this.zzWAo = node;
            return;
        }
        node3.zzYkb(node);
    }

    private Node zzXee(Node node) {
        if (node == this.zzWAo) {
            if (this.zzWAo == this.zzXy2) {
                this.zzWAo = null;
                this.zzXy2 = null;
            } else {
                this.zzWAo = node.zzY4H();
                this.zzWAo.zzXaF(null);
            }
        } else {
            Node node2 = node.zzYRC();
            Node node3 = node.zzY4H();
            node2.zzYkb(node3);
            if (node3 == null) {
                this.zzXy2 = node2;
            } else {
                node3.zzXaF(node2);
            }
        }
        node.zzYkb(null);
        node.zzXaF(null);
        node.zzVTu(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzYGj = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYGj;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

