package executor.core.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ConfigReader {

    @Autowired
    private static Environment env;

    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigReader.class);
    private static Environment environment;

    public ConfigReader(Environment environment) {
        ConfigReader.environment = environment;
    }

    public static String getValue(String key) {
        String value = environment.getProperty(key);
        LOGGER.info("Reading config key: {}, value: {}", key, value);
        return value;
    }
}
