/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.IWarningCallback;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.Section;
import com.aspose.words.Table;
import com.aspose.words.WarningInfo;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.internal.zzYCy;
import com.aspose.words.internal.zzYQu;
import com.aspose.words.internal.zzZTw;
import com.aspose.words.internal.zzZgv;
import com.aspose.words.zz6R;
import com.aspose.words.zzWI6;
import com.aspose.words.zzZ3a;
import com.aspose.words.zzZnv;
import com.aspose.words.zztJ;
import com.aspose.words.zzzN;

final class zzXRz {
    private zzYQu<Table> zzXk0 = new zzYQu();
    private boolean zzZ2K;
    private boolean zzXhw;
    private boolean zzZTf;
    private static int zzZMu = zzXwP.zzXee(ConvertUtil.millimeterToPoint(1.0));
    private IWarningCallback zzXJS;

    zzXRz(int n, IWarningCallback iWarningCallback) {
        this.zzZTf = (n & 0x800) != 0;
        this.zzZ2K = (n & 0x20) != 0;
        this.zzXhw = (n & 0x100) != 0;
        this.zzXJS = iWarningCallback;
    }

    final int visitTableStart(Table table) throws Exception {
        if (table.zzZgJ()) {
            if (this.zzZ2K) {
                boolean bl = false;
                for (Row row : table.getRows()) {
                    for (Cell cell : row.getCells()) {
                        bl |= cell.zzZz1().zz3u();
                    }
                }
                if (bl) {
                    this.zzWBy(table);
                }
                table.zzYoV();
            } else {
                zzzN zzzN2 = new zzzN(table);
                if (zzzN2.zzXG2().length == 0) {
                    this.zzWBy(table);
                }
            }
            table.zzVU8();
            this.zzYkf(table);
            zzXRz.zzY7m(table);
        }
        return 0;
    }

    private boolean zzWBy(Table table) {
        if (this.zzXk0.contains(table)) {
            return false;
        }
        table.zzZBA();
        this.zzXk0.add(table);
        return true;
    }

    private static void zzY7m(Table table) throws Exception {
        if (table.getFirstRow() == null) {
            return;
        }
        zztJ zztJ2 = table.getFirstRow().zzWYl();
        if (!zzXRz.zzXhj(zztJ2)) {
            int n = 0;
            Document document = zztJ2.getVerticalAlignment() == 5 ? zzXwP.zzZ35((Object)table.getDocument(), Document.class) : null;
            if (document != null && !document.getCompatibilityOptions().zzs5()) {
                n = -2;
            }
            table.zzYkf(4190, n);
            table.zzYrL(4200);
        }
    }

    private static boolean zzXhj(zztJ zztJ2) {
        if (zztJ2.getRelativeVerticalPosition() != 2) {
            return true;
        }
        return zztJ2.getVerticalAlignment() == -1 || zztJ2.getVerticalAlignment() == 0;
    }

    final int visitRowStart(Row row) {
        IWarningCallback iWarningCallback;
        String string;
        Object[] objectArray;
        if (this.zzZTf && row.getCells().getCount() > 63) {
            throw new IllegalStateException("More than 63 cells per row is not supported for this file format.");
        }
        if (row.zzWYl().zzY95() > 31680) {
            row.zzWYl().zzX0a(31680);
            objectArray = new Object[]{};
            string = "Table row height exceed maximum allowed, corrected.";
            iWarningCallback = this.zzXJS;
            zz6R.zzZ35(iWarningCallback, 0, string, objectArray);
        }
        if (row.getCells().getCount() >= 63) {
            objectArray = new Object[]{};
            string = "Cell count per row must not exceed 63, document can have problem while opened in MS Word.";
            iWarningCallback = this.zzXJS;
            zz6R.zzZ35(iWarningCallback, 0, string, objectArray);
        }
        zzWI6.zzZAj(row);
        zzXRz.zzZ1L(row);
        return 0;
    }

    static void zzZ1L(Row row) {
        zzXRz.zzXEJ(row.zzWYl(), 5104);
        zzXRz.zzXEJ(row.zzWYl(), 5105);
    }

    private static void zzXEJ(zztJ zztJ2, int n) {
        Object object = zztJ2.zzWnj(n);
        if (object != null && (Integer)object < 0) {
            zzZTw.zzXEJ("Invalid value {0} of attribute {1} removed from a row.", object, n);
            zztJ2.remove(n);
        }
    }

    final int visitTableEnd(Table table) {
        if (table.getFirstRow() == null) {
            this.zzXCr(65536, "Empty table was removed.");
            table.remove();
        }
        return 0;
    }

    final int visitRowEnd(Row row) {
        Cell cell;
        if (row.getFirstCell() == null) {
            this.zzXCr(65536, "Empty table row was removed.");
            row.remove();
            return 0;
        }
        Cell cell2 = row.getFirstCell();
        if (cell2.zzZz1().getHorizontalMerge() == 2) {
            cell2.zzZz1().setHorizontalMerge(1);
        }
        if ((cell = row.getLastCell()).zzZz1().getHorizontalMerge() == 1) {
            cell.zzZz1().setHorizontalMerge(0);
        }
        zzXRz.zzVUd(row);
        return 0;
    }

    private static void zzVUd(Row row) {
        zztJ zztJ2;
        zzZ3a zzZ3a2;
        boolean bl = true;
        boolean bl2 = true;
        for (Cell cell : row.getCells()) {
            bl &= cell.getLastParagraph().zzG().zzXhB();
            bl2 &= cell.getLastParagraph().zzG().zzXmv();
        }
        if (bl && !row.zzWYl().zzXhB()) {
            zzZ3a2 = new zzZ3a(0, row.getFirstCell().getLastParagraph().zzG().getInsertRevision().getAuthor(), row.getFirstCell().getLastParagraph().zzG().getInsertRevision().zzXBk());
            zztJ2 = row.zzWYl();
            zztJ2.zzYEM(14, zzZ3a2);
        }
        if (bl2 && !row.zzWYl().zzXmv()) {
            zzZ3a2 = new zzZ3a(1, row.getFirstCell().getLastParagraph().zzG().getDeleteRevision().getAuthor(), row.getFirstCell().getLastParagraph().zzG().getDeleteRevision().zzXBk());
            zztJ2 = row.zzWYl();
            zztJ2.zzYEM(12, zzZ3a2);
        }
    }

    final int visitCellStart(Cell cell) {
        if (this.zzXhw && !cell.zzZz1().zzWc6(3020)) {
            cell.zzZz1().setPreferredWidth(PreferredWidth.AUTO);
        }
        cell.ensureMinimum();
        if (cell.zzZz1().zz3u()) {
            this.zzXCr(65536, "Invalid cell width, table layout updated.");
            Cell cell2 = cell;
            if (this.zzWBy(cell2.getParentRow().getParentTable())) {
                cell2 = cell;
                this.zzYkf(cell2.getParentRow().getParentTable());
            }
        }
        zzXRz.zzXm3(cell);
        zzWI6.zzc(cell);
        return 0;
    }

    private static void zzXm3(Cell cell) {
        zzZnv zzZnv2 = cell.zzZz1();
        zzXRz.zzWXJ(zzZnv2, 3090);
        zzXRz.zzWXJ(zzZnv2, 3100);
        zzXRz.zzWXJ(zzZnv2, 3070);
        zzXRz.zzWXJ(zzZnv2, 3080);
    }

    private static void zzWXJ(zzZnv zzZnv2, int n) {
        if (!zzZnv2.zzWc6(n)) {
            return;
        }
        zzZnv2.set(n, zzZgv.zzZ16((Integer)zzZnv2.get(n)));
    }

    private static boolean zzXOw(Table table) {
        if (table.getRows().getCount() == 0) {
            return false;
        }
        if (table.zzbN()) {
            return false;
        }
        if (table.zzXjs()) {
            return table.getPreferredWidth().zzXYn() || table.getPreferredWidth().isAuto();
        }
        if (table.getAllowAutoFit()) {
            return !table.getDocument().zzcM().zzWPs.getGrowAutofit();
        }
        return table.getPreferredWidth().zzXYn();
    }

    private void zzYkf(Table table) {
        int n;
        int n2 = table.zzVWh();
        Section section = (Section)table.getAncestor(2);
        int n3 = n = section != null ? section.zzX8i().zzXfx() : 0;
        if ((this.zzZTf || n <= 31680) && n2 > 31680) {
            this.zzWsb(table, 31680);
            n2 = table.zzVWh();
        }
        if (!zzXRz.zzXOw(table)) {
            return;
        }
        int n4 = n2;
        if (table.getAllowAutoFit() || table.getPreferredWidth().getType() == 2) {
            n4 = zz6R.zzYuJ(table);
        }
        if (table.getPreferredWidth().zzXSw() && table.getPreferredWidth().zzZ2o() >= n4) {
            int n5 = n4 = n2 < 31680 ? n2 : 31680;
        }
        if (n2 > n4 + zzZMu) {
            this.zzWsb(table, n4);
        }
    }

    private void zzWsb(Table table, int n) {
        double d;
        int n2 = table.zzVWh();
        double d2 = (double)n / (double)n2;
        if (d < 1.0) {
            if (table.zzZSB()) {
                return;
            }
            this.zzXCr(65536, "Table width exceed maximum allowed, table was resized.");
            for (Row row : table.getRows()) {
                int n3 = 0;
                for (Cell cell : row.getCells()) {
                    cell.zzZz1().zzXcP((int)zzYCy.zzYlH(d2 * (double)cell.zzZz1().zzVVS()));
                    n3 += cell.zzZz1().zzVVS();
                }
                int n4 = row.getLastCell().zzZz1().zzVVS() + (n - n3);
                if (n4 < 0) continue;
                row.getLastCell().zzZz1().zzXcP(n4);
            }
        }
    }

    private void zzXCr(int n, String string) {
        if (this.zzXJS != null) {
            this.zzXJS.warning(new WarningInfo(65536, 17, string));
        }
    }
}

