/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.internal.zzZTw;
import com.aspose.words.internal.zzab;
import com.aspose.words.zz6R;
import com.aspose.words.zzWHJ;
import com.aspose.words.zzYND;
import com.aspose.words.zzf8;

public abstract class Node
implements Cloneable {
    private Node zzZc2;
    private Node zzlr;
    private Node zzVZg;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzXEJ(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzZc2 == null) {
            return null;
        }
        if (this.zzZc2.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzZc2;
    }

    final CompositeNode zzXa1() {
        if (zz6R.zzZyB(this.getParentNode())) {
            return this.getParentNode().zzXa1();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzZc2 != null) {
            return this.zzZc2.getDocument();
        }
        return null;
    }

    final Document zzYbq() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzYrJ() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZGE();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzVZg;
    }

    final Node zzMm() {
        Node node = this;
        while ((node = node.getPreviousSibling()) != null && zz6R.zzZAj(node)) {
        }
        return node;
    }

    final Node zzZ1y() {
        Node node = zz6R.zzYQG(this.getPreviousSibling(), false);
        if (node == null && zz6R.zzZyB(this.getParentNode())) {
            node = this.getParentNode().zzZ1y();
        }
        return node;
    }

    final Node zzZUH() {
        Node node = zz6R.zzZOv(this.getNextSibling(), false);
        if (node == null && zz6R.zzZyB(this.getParentNode())) {
            node = this.getParentNode().zzZUH();
        }
        return node;
    }

    final CompositeNode zzf9() {
        Node node = this;
        while ((node = node.zzZ1y()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzXWF() {
        Node node = this;
        while ((node = node.zzZUH()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzlr;
    }

    final Node zzWPf() {
        Node node = this;
        while ((node = node.getNextSibling()) != null && zz6R.zzZAj(node)) {
        }
        return node;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzYLa() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYaV() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXtw() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zz6R.zzWt8(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzY4H() {
        return this.zzlr;
    }

    final void zzYkb(Node node) {
        this.zzlr = node;
    }

    final Node zzYRC() {
        return this.zzVZg;
    }

    final void zzXaF(Node node) {
        this.zzVZg = node;
    }

    final Node zzXsa() {
        Node node = this;
        if (node.zzlr != null) {
            node = this;
            return node.zzlr;
        }
        return this.getParentNode();
    }

    final int zzZGn() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zz6R.zzX6J(this);
        boolean bl2 = zz6R.zzVPO(this);
        boolean bl3 = zz6R.zz5L(this);
        boolean bl4 = zz6R.zzX0a(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZGn() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 36;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZGn() != 3 && n2 != 6 && n != 27 && n != 33)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ35(isCloneChildren, null);
    }

    Node zzZ35(boolean bl, zzf8 zzf82) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzZc2 != null) {
            node.zzZc2 = this.getDocument().zzZ7n();
        }
        node.zzlr = null;
        node.zzVZg = null;
        if (zzf82 != null) {
            zzf82.zzWXJ(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzX21(StringBuilder stringBuilder) {
        zzXwP.zzXEJ(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzVTu(Node node) {
        this.zzZc2 = node != null ? node : this.getDocument().zzZ7n();
    }

    final void zzXEJ(DocumentBase documentBase) {
        this.zzZc2 = documentBase != null ? documentBase.zzZ7n() : null;
    }

    final boolean zzZnn(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzXXc() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzVRq(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzjB(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzWOk(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzX5Y(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzWHJ zzWHJ2 = zz6R.zzYWe(saveFormat);
        return zzWHJ2.zzXZ6(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzWHJ zzWHJ2 = zz6R.zzZ35(saveOptions);
        return zzWHJ2.zzXZ6(this);
    }

    final Node zzZbm(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zz6R.zzXFq(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzYND zzYCN() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzYND.zzXFh(node);
        }
        return zzYND.zzYF1(this.getParentNode());
    }

    final zzYND zzZPj() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzYND.zzYF1(node);
        }
        return zzYND.zzXFh(this.getParentNode());
    }

    final boolean zz78(Node node) {
        return Node.zzZMN(this, node);
    }

    final boolean zzX4T() {
        return this.getAncestor(1) == null;
    }

    static Node zzXee(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzab<Node> zzab2 = Node.zzZW7(node);
        zzab<Node> zzab3 = Node.zzZW7(node2);
        return Node.zzZ35(zzab2, zzab3);
    }

    static boolean zzZMN(Node node, Node node2) {
        zzab<Node> zzab2;
        if (node == null || node2 == null) {
            return false;
        }
        zzab<Node> zzab3 = Node.zzZW7(node);
        Node node3 = Node.zzZ35(zzab3, zzab2 = Node.zzZW7(node2));
        if (node3 == null) {
            return false;
        }
        zzab<Node> zzab4 = zzab3;
        if (zzab4.size() == 0 || (zzab4 = zzab2).size() == 0) {
            zzab4 = zzab2;
            boolean bl = zzab4.size() > 0;
            return bl;
        }
        Object e = zzab3.peek();
        Object e2 = zzab2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzab<Node> zzZW7(Node node) {
        zzab<Node> zzab2 = new zzab<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzab2.push(node2);
        }
        return zzab2;
    }

    private static Node zzZ35(zzab<Node> zzab2, zzab<Node> zzab3) {
        Node node = null;
        while (zzab2.peek() == zzab3.peek()) {
            node = (Node)zzab2.pop();
            zzab3.pop();
            zzab<Node> zzab4 = zzab2;
            if (zzab4.size() != 0 && (zzab4 = zzab3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    private String zzWoS() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzXwP.zzZ35(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzZTw.zzCs(stringBuilder.toString());
    }

    public String toString() {
        return zzZTw.zzCs(zzZTw.zzXEJ("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzWoS()));
    }

    public void dd() {
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

