/*
 * Decompiled with CFR 0.152.
 */
package com.lark.cn.client;

import com.lark.cn.client.CliOptions;
import com.lark.cn.client.CliOptionsParser;
import com.lark.cn.common.SqlCommandParser;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.TableEnvironment;

public class SqlSubmit {
    private String sqlFilePath;
    private String workSpace;
    private TableEnvironment tEnv;

    public static void main(String[] args) throws Exception {
        CliOptions options = CliOptionsParser.parseClient(args);
        SqlSubmit submit = new SqlSubmit(options);
        submit.run();
    }

    private SqlSubmit(CliOptions options) {
        this.sqlFilePath = options.getSqlFilePath();
        this.workSpace = options.getWorkingSpace();
    }

    private void run() throws Exception {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().useBlinkPlanner().inStreamingMode().build();
        this.tEnv = TableEnvironment.create((EnvironmentSettings)settings);
        List<String> sql = Files.readAllLines(Paths.get(this.workSpace + "/" + this.sqlFilePath, new String[0]));
        List<SqlCommandParser.SqlCommandCall> calls = SqlCommandParser.parse(sql);
        for (SqlCommandParser.SqlCommandCall call : calls) {
            this.callCommand(call);
        }
        this.tEnv.execute("SQL Job");
    }

    private void callCommand(SqlCommandParser.SqlCommandCall cmdCall) {
        switch (cmdCall.command) {
            case SET: {
                this.callSet(cmdCall);
                break;
            }
            case CREATE_TABLE: {
                this.callCreateTable(cmdCall);
                break;
            }
            case INSERT_INTO: {
                this.callInsertInto(cmdCall);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported command: " + (Object)((Object)cmdCall.command));
            }
        }
    }

    private void callSet(SqlCommandParser.SqlCommandCall cmdCall) {
        String key = cmdCall.operands[0];
        String value = cmdCall.operands[1];
        this.tEnv.getConfig().getConfiguration().setString(key, value);
    }

    private void callCreateTable(SqlCommandParser.SqlCommandCall cmdCall) {
        String ddl = cmdCall.operands[0];
        try {
            this.tEnv.sqlUpdate(ddl);
        }
        catch (SqlParserException e) {
            throw new RuntimeException("SQL parse failed:\n" + ddl + "\n", e);
        }
    }

    private void callInsertInto(SqlCommandParser.SqlCommandCall cmdCall) {
        String dml = cmdCall.operands[0];
        try {
            this.tEnv.sqlUpdate(dml);
        }
        catch (SqlParserException e) {
            throw new RuntimeException("SQL parse failed:\n" + dml + "\n", e);
        }
    }
}

