/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zz06;
import com.aspose.words.internal.zzX8;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.internal.zzYXe;
import com.aspose.words.internal.zzZTw;
import com.aspose.words.internal.zzaU;
import com.aspose.words.zzWdP;
import com.aspose.words.zzYND;
import com.aspose.words.zzZsS;
import com.aspose.words.zzZy1;
import com.aspose.words.zzf8;
import com.aspose.words.zzmz;

public class FormField
extends SpecialChar {
    private zzmz zzZoJ;
    private Field zzY22;
    static String zzW21 = zzZTw.zzYQG('\u2002', 5);
    private static final zzaU zzWep = new zzaU("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzmz formFieldPr, zzZsS runPr) {
        super(doc, '\u0001', runPr);
        this.zzZoJ = formFieldPr;
    }

    @Override
    final Node zzZ35(boolean bl, zzf8 zzf82) {
        FormField formField = (FormField)super.zzZ35(bl, zzf82);
        ((FormField)super.zzZ35(bl, zzf82)).zzZoJ = (zzmz)this.zzZoJ.zzYl2();
        formField.zzY22 = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzXwP.zzZ35((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzXa1().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n = FormField.zzZnH(this.getTextInputFormat());
                this.setResult(zzYXe.zzBk((String)newValue, n));
                return;
            }
            case 1: {
                FieldOptions fieldOptions = this.zzYbq().getFieldOptions();
                this.setResult(zzX8.zzZ35(zzXwP.zzX21(newValue), this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzZy1.zzWsb((zz06)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    private static int zzZnH(String string) {
        string = string.toLowerCase();
        switch (zzWep.zzYSG(string)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private FieldStart zzXfP() {
        int n = 0;
        zzYND zzYND2 = zzYND.zzYF1(this);
        do {
            Node node = zzYND2.getNode();
            switch (node.getNodeType()) {
                case 22: {
                    if (n == 0) {
                        return (FieldStart)node;
                    }
                    --n;
                    break;
                }
                case 24: {
                    ++n;
                }
            }
        } while (zzYND2.zzZ35(null, false, true, true, false, false));
        return null;
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZoJ.getName();
    }

    public void setName(String value) throws Exception {
        zzXwP.zzXEJ((Object)value, "value");
        this.zzZoJ.setName(value);
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(this.zzZoJ.getName());
        }
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzfb() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    final Field getField() {
        FieldStart fieldStart;
        if (this.zzY22 == null && (fieldStart = this.zzXfP()) != null) {
            this.zzY22 = fieldStart.getField();
        }
        return this.zzY22;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().zzXaK(true);
                if (zzZTw.zzWXU(string, zzW21)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzWkH();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzXwP.zzXEJ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzX8.zzYh6(value) != 0);
                return;
            }
            case 83: {
                this.zzZsO(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZoJ.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZoJ.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZoJ.zzY1D();
    }

    public void setOwnStatus(boolean value) {
        this.zzZoJ.zzYjp(value);
    }

    public String getHelpText() {
        return this.zzZoJ.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZoJ.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZoJ.zzYTG();
    }

    public void setOwnHelp(boolean value) {
        this.zzZoJ.zzGc(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZoJ.zzWpI();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZoJ.zzZEf(value);
    }

    public String getEntryMacro() {
        return this.zzZoJ.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZoJ.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZoJ.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZoJ.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZoJ.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZoJ.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZoJ.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZoJ.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZoJ.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZoJ.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZoJ.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZoJ.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzVRq(21);
            zzWdP.zzZ35(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzYbq());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZoJ.zzVSq();
    }

    public void setMaxLength(int value) {
        this.zzZoJ.zz9s(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZoJ.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzmz zzmz2 = this.zzZoJ;
        if (zzmz2.zzWc6(21070)) {
            return this.zzZoJ.zzYBO();
        }
        return this.zzZoJ.zzZTj();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZoJ.zzYnF(value);
    }

    final String zzWkH() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzZsO(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzYXe.zzc(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzmz zzmz2 = this.zzZoJ;
        if (zzmz2.zzWc6(21010)) {
            return this.zzZoJ.zzZYt();
        }
        return this.zzZoJ.zzZbW();
    }

    public void setChecked(boolean value) {
        this.zzZoJ.zzWWl(value);
    }

    public boolean getDefault() {
        return this.zzZoJ.zzZbW();
    }

    public void setDefault(boolean value) {
        this.zzZoJ.zzVPd(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZoJ.zzXLs();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZoJ.zzWFT(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZoJ.zzY3N();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZoJ.zzWNt(zzXwP.zzYyM(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzXwP.zzZ35((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzXwP.zzZ35((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzmz zzWLL() {
        return this.zzZoJ;
    }
}

