/*
 * Decompiled with CFR 0.152.
 */
package com.lark.cn.sql;

import com.lark.cn.common.SqlCommandParser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.java.StreamTableEnvironment;

public class StreamJobExecutor {
    private StreamTableEnvironment streamTableEnvironment;
    private StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();

    public StreamJobExecutor() {
        this.init();
    }

    private void init() {
        this.streamTableEnvironment = StreamTableEnvironment.create((StreamExecutionEnvironment)this.env);
    }

    public void invoke(String sql) {
        if (this.streamTableEnvironment == null) {
            throw new RuntimeException("StreamTableEnvironment is not init");
        }
        if (StringUtils.isEmpty((CharSequence)sql) || sql.split(";").length < 1) {
            throw new RuntimeException("SQL is not standard");
        }
        List<String> sqlSegment = Arrays.asList(sql.split(";"));
        for (String segment : sqlSegment) {
            Optional<SqlCommandParser.SqlCommandCall> call = SqlCommandParser.parse(segment);
            this.callCommand(call.get());
        }
        try {
            this.env.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void callCommand(SqlCommandParser.SqlCommandCall cmdCall) {
        switch (cmdCall.command) {
            case SELECT: {
                this.callSelect(cmdCall);
                break;
            }
            case CREATE_TABLE: {
                this.callCreateTable(cmdCall);
                break;
            }
            case INSERT_INTO: {
                this.callInsertInto(cmdCall);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported command: " + (Object)((Object)cmdCall.command));
            }
        }
    }

    private void callCreateTable(SqlCommandParser.SqlCommandCall cmdCall) {
        String ddl = cmdCall.operands[0];
        try {
            this.streamTableEnvironment.sqlUpdate(ddl);
        }
        catch (SqlParserException e) {
            throw new RuntimeException("SQL parse failed:\n" + ddl + "\n", e);
        }
    }

    private void callInsertInto(SqlCommandParser.SqlCommandCall cmdCall) {
        String dml = cmdCall.operands[0];
        try {
            this.streamTableEnvironment.sqlUpdate(dml);
        }
        catch (SqlParserException e) {
            throw new RuntimeException("SQL parse failed:\n" + dml + "\n", e);
        }
    }

    private void callSelect(SqlCommandParser.SqlCommandCall cmdCall) {
        String dql = cmdCall.operands[0];
        try {
            Table table = this.streamTableEnvironment.sqlQuery(dql);
            table.printSchema();
        }
        catch (SqlParserException e) {
            throw new RuntimeException("SQL parse failed:\n" + dql + "\n", e);
        }
    }
}

