/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzW3i;
import com.aspose.words.internal.zzWwK;
import com.aspose.words.internal.zzX6W;
import com.aspose.words.internal.zzX7y;
import com.aspose.words.internal.zzXwP;
import com.aspose.words.internal.zzYXe;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zz1i;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zz4U = new HashMap();
    private static HashMap<Integer, Integer> zzW2Z = new HashMap();
    private static HashMap<Integer, Integer> zzZ6k = new HashMap();
    private static HashMap<Integer, Integer> zzZ28 = new HashMap();
    private static HashMap<Integer, Integer> zzX7m = new HashMap();
    private static HashMap<Integer, Integer> zzZBl = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzXwP.zzZ35(fileName, "fileName");
        try (zzW3i zzW3i2 = zzXwP.zzYiy(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzqL(zzW3i2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzqL(zzX6W.zzZ35(stream));
    }

    static FileFormatInfo zzqL(zzWwK zzWwK2) throws Exception {
        if (zzWwK2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz1i zz1i2 = new zz1i();
            zzWwK zzWwK3 = zzWwK2;
            zz1i zz1i3 = zz1i2;
            return zz1i2.zzXEJ(zzWwK3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ35(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzX7j(zzX7y.zzWqz(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzW02(zzX7y.zzWqz(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzYXe.zzZbE(string = zzX7y.zzX3Z(FileFormatUtil.zz1i(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzX7j(FileFormatUtil.zzWFn(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzW02(FileFormatUtil.zz1i(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzX7y.zzX3Z(FileFormatUtil.zzWFn(saveFormat));
        if (zzYXe.zzZbE(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzW02(zzX7y.zzWBy(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzX7y.zzX3Z(FileFormatUtil.zzYim(imageType));
    }

    static Exception zzZ35(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzVWw(int n) {
        return zzX7y.toString(FileFormatUtil.zzWFn(n));
    }

    static int zzW02(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXwP.zzZ35(zzX7m, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzZH4(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXwP.zzZ35(zzZBl, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzZU3(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zz1i(int n) {
        return zzXwP.zzZ35(zz4U, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzWFn(int n) {
        return zzXwP.zzZ35(zzW2Z, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYim(int n) {
        return zzXwP.zzZ35(zzZ6k, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzX7j(int n) {
        return zzXwP.zzZ35(zzZ28, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzX21(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzXwP.zzXEJ(zzX7m, Integer.valueOf(n), Integer.valueOf(n2));
            zzXwP.zzXEJ(zzW2Z, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZ28.containsKey(n)) {
                zzXwP.zzXEJ(zzZ28, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzXwP.zzXEJ(zz4U, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzXwP.zzXEJ(zzZBl, Integer.valueOf(n), Integer.valueOf(n4));
            zzXwP.zzXEJ(zzZ6k, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzX21(11, 10, 10, 1);
        FileFormatUtil.zzX21(11, 0, 0, 1);
        FileFormatUtil.zzX21(12, 11, 11, 1);
        FileFormatUtil.zzX21(13, 20, 20, 1);
        FileFormatUtil.zzX21(13, 0, 254, 1);
        FileFormatUtil.zzX21(14, 21, 21, 1);
        FileFormatUtil.zzX21(15, 22, 22, 1);
        FileFormatUtil.zzX21(16, 23, 23, 1);
        FileFormatUtil.zzX21(18, 24, 24, 1);
        FileFormatUtil.zzX21(19, 25, 25, 1);
        FileFormatUtil.zzX21(20, 26, 26, 1);
        FileFormatUtil.zzX21(21, 27, 27, 1);
        FileFormatUtil.zzX21(24, 30, 30, 1);
        FileFormatUtil.zzX21(17, 31, 31, 1);
        FileFormatUtil.zzX21(25, 50, 50, 1);
        FileFormatUtil.zzX21(26, 45, 255, 1);
        FileFormatUtil.zzX21(27, 51, 51, 1);
        FileFormatUtil.zzX21(28, 0, 52, 1);
        FileFormatUtil.zzX21(22, 60, 60, 1);
        FileFormatUtil.zzX21(23, 61, 61, 1);
        FileFormatUtil.zzX21(32, 40, 255, 1);
        FileFormatUtil.zzX21(39, 47, 255, 1);
        FileFormatUtil.zzX21(40, 48, 255, 1);
        FileFormatUtil.zzX21(33, 41, 255, 1);
        FileFormatUtil.zzX21(34, 46, 255, 1);
        FileFormatUtil.zzX21(36, 42, 255, 1);
        FileFormatUtil.zzX21(35, 44, 255, 1);
        FileFormatUtil.zzX21(29, 52, 255, 1);
        FileFormatUtil.zzX21(30, 70, 62, 1);
        FileFormatUtil.zzX21(31, 73, 63, 1);
        FileFormatUtil.zzX21(37, 71, 255, 1);
        FileFormatUtil.zzX21(8, 100, 255, 1);
        FileFormatUtil.zzX21(9, 105, 255, 1);
        FileFormatUtil.zzX21(6, 101, 255, 6);
        FileFormatUtil.zzX21(7, 102, 255, 7);
        FileFormatUtil.zzX21(5, 104, 255, 5);
        FileFormatUtil.zzX21(4, 0, 255, 4);
        FileFormatUtil.zzX21(3, 0, 255, 3);
        FileFormatUtil.zzX21(38, 72, 255, 1);
        FileFormatUtil.zzX21(2, 103, 255, 2);
    }
}

