// 文件路径：ruoyi-system/src/main/java/com/ruoyi/dealer/service/impl/DealerRoundResultServiceImpl.java
package com.ruoyi.dealer.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupListRes;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupResultDto;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupResultRes;
import com.ruoyi.dealer.domain.dto.DealerRoundDetailListRes;
import com.ruoyi.dealer.mapper.DealerRoundResultMapper;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 经销商轮次结果 Service 实现类
 */
@Service
public class DealerRoundResultServiceImpl extends ServiceImpl<DealerRoundResultMapper, DealerRoundResult> implements IDealerRoundResultService {
    @Override
    public List<DealerBigScreenGroupListRes> groupList(String CategoryName) {
        // 查询第一列分组的前几名
        List<DealerRoundResult> resultList = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getDealerCategory, CategoryName)
                .eq(DealerRoundResult::getRoundTime, 1)
                .orderByDesc(DealerRoundResult::getPaymentPercentage, DealerRoundResult::getPaymentTtl)
        );

        List<DealerBigScreenGroupListRes> list = new ArrayList<>();
        resultList.forEach(item -> {
            DealerBigScreenGroupListRes res = new DealerBigScreenGroupListRes();
            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setGroupName(item.getGroupName());
            res.setRoundTime(item.getRoundTime());
            res.setGoalTtlAct(item.getGoalTtlAct());
            res.setPaymentTtl(item.getPaymentTtl());

            res.setPaymentPercentage(Math.round(item.getPaymentTtl() * 100.0 / item.getGoalTtlAct()) + "%");
            list.add(res);
        });

        return list;
    }

    @Override
    public List<DealerBigScreenGroupResultRes> groupTotalList() {
        List<DealerBigScreenGroupResultDto> dealerBigScreenGroupResultRes = this.getBaseMapper().groupTotalList();
        List<DealerBigScreenGroupResultRes> list = new ArrayList<>();
        dealerBigScreenGroupResultRes.forEach(item -> {
            DealerBigScreenGroupResultRes res = new DealerBigScreenGroupResultRes();
            res.setRoundTime(item.getRoundTime());
            res.setGroupName(item.getGroupName());
            res.setPaymentTtl(item.getPaymentTtl());
            res.setGoalTtlAct(item.getGoalTtlAct());

            res.setPaymentPercentage(Math.round(item.getPaymentPercentage()) + "%");
            list.add(res);
        });
        return list;
    }

    @Override
    public List<DealerRoundDetailListRes> groupRoundList(Integer roundTime ,String phone,String dealerName) {
        List<DealerRoundResult> dealerBigScreenGroupResultRes = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, roundTime)
                .like(ObjectUtil.isNotEmpty(phone), DealerRoundResult::getPhone, phone)
                .like(ObjectUtil.isNotEmpty(dealerName), DealerRoundResult::getDealerName, dealerName)
                .orderByDesc(DealerRoundResult::getSalesRegionGroupName, DealerRoundResult::getPaymentPercentage));
        List<DealerRoundDetailListRes> list = new ArrayList<>();
        dealerBigScreenGroupResultRes.forEach(item -> {
            DealerRoundDetailListRes res = new DealerRoundDetailListRes();
            res.setRoundTime(item.getRoundTime());
            res.setGroupName(item.getGroupName());

            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setPaymentTtl(item.getPaymentTtl());
            res.setGoalTtlAct(item.getGoalTtlAct());

            res.setPaymentPercentage(Math.round(item.getPaymentTtl() * 100.0 / item.getGoalTtlAct()) + "%");
            list.add(res);

        });


        return list;
    }

    @Override
    public int initRoundInfo() {

        List<DealerRoundResult> round2Results = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, 2)
        );
        if(round2Results.size()>0){
            throw new RuntimeException("第二轮数据已存在");
        }
        // 获取所有经销商信息
        List<DealerRoundResult> resultList = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, 1)
        );
        // 复制所有数据
        // 先清空id
        resultList.forEach(item -> {
            item.setResultId(null);
            item.setRoundTime(2);
            // 覆盖字段
            item.setGroupName(item.getSalesRegionGroupName());
        });
        this.saveBatch(resultList);
        return 0;
    }
}
