package com.ruoyi.dealer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.constant.Constants;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.NumberUtil;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.WechatDealerRoundInfoRes;
import com.ruoyi.dealer.mapper.DealerBaseInfoMapper;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import com.ruoyi.system.service.ISysConfigService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * 参数配置 服务层实现
 *
 * @author ruoyi
 */
@Service
public class DealerBaseInfoImpl extends ServiceImpl<DealerBaseInfoMapper, DealerBaseInfo> implements IDealerBaseInfoService {
//    @Autowired
//    private DealerBaseInfoMapper dealerBaseInfoMapper;
//    @Autowired
//    private DealerRoundInfoService dealerRoundInfoService;
    @Autowired
    private IDealerRoundResultService resultService;
    @Autowired
    private ISysConfigService configService;

    @Override
    public List<DealerBaseInfo> queryList(DealerBaseInfo sysStudent) {
        // 注意：mybatis-plus lambda 模式不支持 eclipse 的编译器
        QueryWrapper<DealerBaseInfo> queryWrapper = Wrappers.query();
        return this.list(queryWrapper);
    }

    @Override
    public WechatDealerRoundInfoRes getDealerRoundInfoByDealerId(Long dealerId) {

        String roundConfig = configService.selectConfigByKeyFromDb(Constants.DEALER_ROUND);
        Integer round = Integer.parseInt(roundConfig);

        DealerBaseInfo dealerBaseInfo = this.getById(dealerId);
        if (dealerBaseInfo == null) {
            throw new ServiceException("经销商不存在");
        }
        // 查询当前的轮次
        WechatDealerRoundInfoRes roundInfoRes = new WechatDealerRoundInfoRes();
        BeanUtils.copyProperties(dealerBaseInfo, roundInfoRes);
        // 获取支付百分比 保留两位小数点


//        roundInfoRes.setPaymentPercentage(getPercentage(dealerBaseInfo.getPaymentTtl(),dealerBaseInfo.getGoalTtlAct()) + "%");
        roundInfoRes.setPaymentPercentage(NumberUtil.formatNumber(dealerBaseInfo.getPaymentPercentage(),2) + "%");

        // 轮次
        roundInfoRes.setRoundTime(round);
        // 区分分组信息
        // 查询结果表，如果有值，更新覆盖
        DealerRoundResult result = resultService.getOne(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, round)
                .eq(DealerRoundResult::getDealerId, dealerId));
        if (result != null) {
            roundInfoRes.setPaymentTtl(result.getPaymentTtl());
//            roundInfoRes.setPaymentPercentage(getPercentage(result.getPaymentTtl(),dealerBaseInfo.getGoalTtlAct()) + "%");
            roundInfoRes.setPaymentPercentage(NumberUtil.formatNumber(result.getPaymentPercentage(),2) + "%");
        }
        // 没有结果数据 数据怎么初始化 ？？

        return roundInfoRes;
    }

    private String getPercentage(Integer paymentTtl, Integer goalTtlAct) {
        return new BigDecimal(paymentTtl)
                .multiply(new BigDecimal(100))
                .divide(new BigDecimal(goalTtlAct),2,RoundingMode.HALF_UP )
                .stripTrailingZeros()
                .toPlainString();

    }
}
