// 文件路径：ruoyi-system/src/main/java/com/ruoyi/dealer/service/impl/DealerRoundResultServiceImpl.java
package com.ruoyi.dealer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupListRes;
import com.ruoyi.dealer.mapper.DealerRoundResultMapper;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 经销商轮次结果 Service 实现类
 */
@Service
public class DealerRoundResultServiceImpl extends ServiceImpl<DealerRoundResultMapper, DealerRoundResult> implements IDealerRoundResultService {
    @Override
    public List<DealerBigScreenGroupListRes> groupList(String CategoryName) {
        // 查询第一列分组的前几名
        List<DealerRoundResult> resultList = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getDealerCategory, CategoryName)
                .eq(DealerRoundResult::getRoundTime, 1)
                .orderByDesc(DealerRoundResult::getPaymentPercentage, DealerRoundResult::getPaymentTtl)
                 );

//        this.getBaseMapper().getGroupList(CategoryName);

        List<DealerBigScreenGroupListRes> list =new ArrayList<>();
        resultList.forEach(item -> {
            DealerBigScreenGroupListRes res = new DealerBigScreenGroupListRes();
            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setGroupName(item.getGroupName());
            res.setRoundTime(item.getRoundTime());
            res.setPaymentPercentage(Math.round(item.getPaymentTtl() * 100.0 / item.getGoalTtlAct() )  + "%");
            list.add(res);
        });

        return list;
    }
 }
