package com.ruoyi.dealer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.dto.DealerBaseInfoDto;
import com.ruoyi.dealer.domain.dto.RoundInfoDto;
import com.ruoyi.dealer.domain.dto.WechatDealerRoudInfoRes;
import com.ruoyi.dealer.mapper.DealerBaseInfoMapper;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 参数配置 服务层实现
 *
 * @author ruoyi
 */
@Service
public class DealerBaseInfoImpl extends ServiceImpl<DealerBaseInfoMapper, DealerBaseInfo> implements IDealerBaseInfoService {
    @Autowired
    private DealerBaseInfoMapper dealerBaseInfoMapper;
    @Autowired
    private DealerRoundInfoService dealerRoundInfoService;

    @Override
    public List<DealerBaseInfo> queryList(DealerBaseInfo sysStudent) {
        // 注意：mybatis-plus lambda 模式不支持 eclipse 的编译器
        // LambdaQueryWrapper<SysStudent> queryWrapper = Wrappers.lambdaQuery();
        // queryWrapper.eq(SysStudent::getStudentName, sysStudent.getStudentName());
        QueryWrapper<DealerBaseInfo> queryWrapper = Wrappers.query();
//        if (StringUtils.isNotEmpty(sysStudent.getStudentName())) {
//            queryWrapper.eq("student_name", sysStudent.getStudentName());
//        }
//        if (StringUtils.isNotNull(sysStudent.getStudentAge())) {
//            queryWrapper.eq("student_age", sysStudent.getStudentAge());
//        }
//        if (StringUtils.isNotEmpty(sysStudent.getStudentHobby())) {
//            queryWrapper.eq("student_hobby", sysStudent.getStudentHobby());
//        }
        return this.list(queryWrapper);
    }

    @Override
    public WechatDealerRoudInfoRes getInfoById(Long dealerBaseInfoId) {
        DealerBaseInfo dealerBaseInfo = this.getById(dealerBaseInfoId);
        if (dealerBaseInfo == null) {
            throw new ServiceException("经销商不存在");
        }
        // 查询当前的轮次
        WechatDealerRoudInfoRes dealerBaseInfoRes = new WechatDealerRoudInfoRes();
        BeanUtils.copyProperties(dealerBaseInfo, dealerBaseInfoRes);
        dealerBaseInfoRes.setRoundTime(1);
        dealerBaseInfoRes.setReward("老铺黄金-葫芦1号吊坠");
        return dealerBaseInfoRes;
    }
}
