package com.ruoyi.dealer.domain.dto;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class WechatDealerRoudInfoRes {
    private Integer roundTime;
    private String reward;
    /**
     * 销售大区（非空）
     */
    private Long dealerId;
    /**
     * 销售大区（非空）
     */
    private String salesRegion;

    /**
     * 销售战区（非空）
     */
    private String salesTheater;

    /**
     * 经销商名称（非空）
     * TODO 脱敏经销商名称
     */
    private String dealerName;

    /**
     * 经销商类型
     */
    private String dealerType;

    /**
     * 已完成
     */
    private String dealerDone;

    /**
     * 活动目标TTL
     */
    private Integer goalTtlAct;

    /**
     * 常规目标
     */
//    private Integer goalRegular;

    /**
     * 活动礼盒目标
     */
//    private Integer goalGiftBox;

    /**
     * 经销商分类
     */
    private String dealerCategory;

    /**
     * 预付款TTL
     */
    private Integer paymentTtl;

    /**
     * 预付款成品
     */
//    private Integer paymentProduct;

    /**
     * 预付款分类礼盒
     */
//    private Integer paymentGiftBox;

    /**
     * 预付款百分比（%）
     */
    private BigDecimal paymentPercentage;
    /**
     * TODO 脱敏手机号
     */
    private String phone;

    /**
     * 分组名称-按照目标分组 A 麒麟组  B 青龙组  C 鲲鹏组
     */
    private String groupName;
    /**
     * 销售大区分组名称
     */
    private String salesRegionGroupName;



}
