package com.ruoyi.dealer.domain.dto;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class DealerBaseInfoDto {
    /**
     * 销售大区（非空）
     */
    private Long id;
    /**
     * 销售大区（非空）
     */
    private String salesRegion;

    /**
     * 销售战区（非空）
     */
    private String salesTheater;

    /**
     * 经销商名称（非空）
     */
    private String dealerName;

    /**
     * 经销商类型
     */
    private String dealerType;

    /**
     * 已完成
     */
    private String dealerDone;

    /**
     * 活动目标TTL
     */
    private Integer goalTtlAct;

    /**
     * 常规目标
     */
    private Integer goalRegular;

    /**
     * 活动礼盒目标
     */
    private Integer goalGiftBox;

    /**
     * 经销商分类
     */
    private String dealerCategory;

    /**
     * 预付款TTL
     */
    private Integer paymentTtl;

    /**
     * 预付款成品
     */
    private Integer paymentProduct;

    /**
     * 预付款分类礼盒
     */
    private Integer paymentGiftBox;

    /**
     * 预付款百分比（%）
     */
    private BigDecimal paymentPercentage;
}
