package com.ruoyi.web.controller.dealer;

import java.util.Arrays;
import java.util.List;

import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.dto.WechatDealerRoundInfoReq;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;

import javax.validation.Valid;

/**
 * 经销商信息Controller
 *
 * @author ruoyi
 */
@RestController
@RequestMapping("/dealer/baseInfo")
public class DealerBaseInfoController extends BaseController
{
    @Autowired
    private IDealerBaseInfoService dealerBaseInfoService;
    @Autowired
    private DealerRoundInfoService dealerRoundInfoService;

    /**
     * 查询经销商信息列表
     */
//    @PreAuthorize("@ss.hasPermi('system:dealerBaseInfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(DealerBaseInfo dealerBaseInfo)
    {
        startPage();
        List<DealerBaseInfo> list = dealerBaseInfoService.queryList(dealerBaseInfo);
        return getDataTable(list);
    }

    /**
     * 导出经销商信息列表
     */
//    @PreAuthorize("@ss.hasPermi('system:dealerBaseInfo:export')")
    @Log(title = "经销商信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(DealerBaseInfo dealerBaseInfo)
    {
        List<DealerBaseInfo> list = dealerBaseInfoService.queryList(dealerBaseInfo);
        ExcelUtil<DealerBaseInfo> util = new ExcelUtil<DealerBaseInfo>(DealerBaseInfo.class);
        return util.exportExcel(list, "dealerBaseInfo");
    }

    /**
     * 获取经销商信息详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:dealerBaseInfo:query')")
    @GetMapping(value = "/round")
    public AjaxResult getRoundInfo()
    {
        Long userId = SecurityUtils.getUserId();
        return AjaxResult.success(dealerBaseInfoService.getInfoById(userId));
    }

    /**
     * 新增经销商信息
     */
//    @PreAuthorize("@ss.hasPermi('system:dealerBaseInfo:add')")
    @Log(title = "经销商填写预付款信息", businessType = BusinessType.INSERT)
    @PostMapping(value = "/round")
    public AjaxResult addRoundInfo(@Validated @RequestBody WechatDealerRoundInfoReq dealerRoundInfoReq)
    {
        return toAjax(dealerRoundInfoService.saveRoundInfo(dealerRoundInfoReq));
    }

    /**
     * 修改经销商信息
     */
//    @PreAuthorize("@ss.hasPermi('system:dealerBaseInfo:edit')")
    @Log(title = "经销商信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DealerBaseInfo DealerBaseInfo)
    {
        return toAjax(dealerBaseInfoService.updateById(DealerBaseInfo));
    }

    /**
     * 删除经销商信息
     */
//    @PreAuthorize("@ss.hasPermi('system:dealerBaseInfo:remove')")
    @Log(title = "经销商信息", businessType = BusinessType.DELETE)
    @DeleteMapping("/{dealerBaseInfoIds}")
    public AjaxResult remove(@PathVariable Long[] dealerBaseInfoIds)
    {
        return toAjax(dealerBaseInfoService.removeByIds(Arrays.asList(dealerBaseInfoIds)));
    }
}
