package com.ruoyi.dealer.domain.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 经销商轮次填写信息
 * 对应表：dealer_round_info
 */
@Data
@TableName("dealer_round_info")
public class DealerRoundInfo {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long roundId;

    /**
     * 经销商id
     */
    private Long dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 当前轮次
     */
    private Integer roundTime;

    /**
     * 增加的预付款万
     */
    private Integer paymentTtlNew;
    /**
     * 活动目标TTL-冗余
     */
    private Integer goalTtlAct;

    /**
     * 增加前预付款
     */
    private Integer paymentTtlPre;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    private Integer repetition;
}
