package com.ruoyi.dealer.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.constant.Constants;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.DealerBigScreenDynamicRes;
import com.ruoyi.dealer.domain.dto.DealerRoundInfo;
import com.ruoyi.dealer.domain.dto.TurnRoundInfoReq;
import com.ruoyi.dealer.domain.dto.WechatDealerRoundInfoReq;
import com.ruoyi.dealer.mapper.DealerRoundInfoMapper;
import com.ruoyi.dealer.service.DealerRoundInfoService;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import com.ruoyi.system.domain.SysConfig;
import com.ruoyi.system.service.ISysConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 经销商轮次填写信息Service实现类
 *
 * @author ruoyi
 * @date 2025-10-xx
 */
@Service
public class DealerRoundInfoServiceImpl extends ServiceImpl<DealerRoundInfoMapper, DealerRoundInfo> implements DealerRoundInfoService {

    @Autowired
    private IDealerRoundResultService roundResultService;
    @Autowired
    private ISysConfigService configService;
    @Autowired
    private IDealerBaseInfoService dealerBaseInfoService;

    @Override
    public DealerRoundInfo getByDealerId(Long dealerBaseInfoId) {
        //
        return null;
    }

    @Override
    public int saveRoundInfo(WechatDealerRoundInfoReq dealerRoundInfoReq) {

        String config = configService.selectConfigByKeyFromDb(Constants.DEALER_ROUND_OVER);
        Boolean roundOver = Boolean.parseBoolean(config);
        if (roundOver) {
            throw new ServiceException("当前轮次活动已经结束");
        }
        Long userId = SecurityUtils.getUserId();
        String dealerName = SecurityUtils.getLoginUser().getUsername();
        String phone = SecurityUtils.getLoginUser().getUser().getPhonenumber();


        // 记录当前轮次的填写情况
        DealerRoundInfo dealerRoundInfo = new DealerRoundInfo();
        dealerRoundInfo.setDealerId(userId);
        dealerRoundInfo.setDealerName(dealerName);
        dealerRoundInfo.setPhone(phone);

        dealerRoundInfo.setRoundTime(dealerRoundInfoReq.getRoundTime());

        dealerRoundInfo.setGoalTtlAct(dealerRoundInfoReq.getGoalTtlAct());
        dealerRoundInfo.setPaymentTtlNew(dealerRoundInfoReq.getPaymentTtlNew());
        dealerRoundInfo.setPaymentTtlPre(dealerRoundInfoReq.getPaymentTtl());

        this.save(dealerRoundInfo);


        //更新结果表数据
        DealerRoundResult resultInfo = new DealerRoundResult();
        resultInfo.setDealerId(dealerRoundInfoReq.getDealerId());
        resultInfo.setDealerName(dealerRoundInfoReq.getDealerName());

        //TODO  手机号传输？ 是脱敏手机号
        resultInfo.setPhone(dealerRoundInfoReq.getPhone());
        resultInfo.setRoundTime(dealerRoundInfoReq.getRoundTime());
        resultInfo.setPaymentTtl(dealerRoundInfoReq.getPaymentTtlNew());
        resultInfo.setPaymentTtlPre(dealerRoundInfoReq.getPaymentTtl());
        resultInfo.setPaymentPercentage(new BigDecimal(dealerRoundInfoReq.getPaymentTtlNew()).multiply(new BigDecimal(100)).divide(new BigDecimal(dealerRoundInfoReq.getGoalTtlAct()), 4, BigDecimal.ROUND_HALF_UP));
        resultInfo.setGoalTtlAct(dealerRoundInfoReq.getGoalTtlAct());

        resultInfo.setDealerCategory(dealerRoundInfoReq.getDealerCategory());
        resultInfo.setGroupName(dealerRoundInfoReq.getGroupName());
        // 查询
        DealerBaseInfo baseInfo = dealerBaseInfoService.getById(userId);
        resultInfo.setSalesRegionGroupName(baseInfo.getSalesRegionGroupName());


        // 查询当前经销商的结果
        DealerRoundResult existResult = roundResultService.getOne(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getDealerId, dealerRoundInfoReq.getDealerId())
                .eq(DealerRoundResult::getRoundTime, dealerRoundInfoReq.getRoundTime())
        );

        if (ObjectUtil.isNotEmpty(existResult)) {
            // 修改结果表数据
            resultInfo.setResultId(existResult.getResultId());
            resultInfo.setVersion(existResult.getVersion() + 1);
        } else {
            // 第一次只能新增 新增结果表数据
            resultInfo.setVersion(1);
        }
        roundResultService.saveOrUpdate(resultInfo);

        return 1;
    }

    /**
     * 只有第一轮调用，第2轮不调用
     *
     * @param roundId
     * @return
     */
    @Override
    public List<DealerBigScreenDynamicRes> dynamicList(Integer roundId) {
        // TODO 当前轮次
        // 返回经销商信息 名称 手机号 达成进度
        Wrapper<DealerRoundInfo> query = new LambdaQueryWrapper<DealerRoundInfo>()
                .eq(DealerRoundInfo::getRoundTime, 1)
                .gt(ObjectUtil.isNotEmpty(roundId), DealerRoundInfo::getRoundId, roundId);
        List<DealerRoundInfo> infoList = this.list(query);

        List<DealerBigScreenDynamicRes> list = infoList.stream().map(info -> {
            DealerBigScreenDynamicRes res = new DealerBigScreenDynamicRes();
            res.setRoundTime(info.getRoundTime());
            res.setDealerId(info.getDealerId());
            res.setDealerName(info.getDealerName());
            res.setPhone(info.getPhone());
            res.setGoalTtlAct(info.getGoalTtlAct());
            res.setPaymentTtl(info.getPaymentTtlNew());
            res.setPhone(info.getPhone());
            res.setPaymentChange(info.getPaymentTtlNew() > info.getPaymentTtlPre() ? "up" : "down");
            res.setPaymentPercentage(new BigDecimal(info.getPaymentTtlNew()).multiply(new BigDecimal(100)).divide(new BigDecimal(info.getGoalTtlAct()), 0, BigDecimal.ROUND_HALF_UP) + "%");

            res.setRoundId(info.getRoundId());
            return res;
        }).collect(Collectors.toList());

        return list;
    }

    @Override
    public List<SysConfig> turnRoundInfo(TurnRoundInfoReq turnRoundInfoReq) {
        SysConfig sysConfigRoundOver = configService.selectConfigObjByKey(Constants.DEALER_ROUND_OVER);
        sysConfigRoundOver.setConfigValue(turnRoundInfoReq.getRoundOver().toString());
        configService.updateConfig(sysConfigRoundOver);

        SysConfig sysConfigRound = configService.selectConfigObjByKey(Constants.DEALER_ROUND);
        sysConfigRound.setConfigValue(turnRoundInfoReq.getRoundTime().toString());
        configService.updateConfig(sysConfigRound);

        List<SysConfig> list = new ArrayList<>();
        list.add(sysConfigRound);
        list.add(sysConfigRoundOver);
        return list;
    }


}
