package com.ruoyi.dealer.domain.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class WechatDealerRoundInfoReq {
    @NotNull(message = "轮次不能为空")
    private Integer roundTime;
    // private String reward;
    /**
     * 经销商id
     */
    private Long dealerId;
    /**
     * 销售大区（非空）
     */
    private String salesRegion;

    /**
     * 销售战区（非空）
     */
    private String salesTheater;

    /**
     * 经销商名称（非空）
     */
    private String dealerName;

    /**
     * 经销商类型
     */
    private String dealerType;

    /**
     * 已完成
     */
//    private String dealerDone;

    /**
     * 活动目标TTL
     */
    private Integer goalTtlAct;

    /**
     * 常规目标
     */
    private Integer goalRegular;

    /**
     * 活动礼盒目标
     */
    private Integer goalGiftBox;

    /**
     * 经销商分类
     */
    private String dealerCategory;


    /**
     * 预付款TTL
     */
    private Integer paymentTtl;


    /**
     * 预付款TTL-填写的
     */
    @NotNull(message = "最新的预付款TTL不能为空")
    private Integer paymentTtlNew;


    /**
     * 预付款百分比（%）
     */
    private String  paymentPercentage;

    /**
     * 脱敏手机号
     */
    private String phone;

    private String groupName;

}
