// 文件路径：ruoyi-system/src/main/java/com/ruoyi/dealer/service/impl/DealerRoundResultServiceImpl.java
package com.ruoyi.dealer.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dealer.domain.DealerBaseInfo;
import com.ruoyi.dealer.domain.DealerRoundResult;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupListRes;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupResultDto;
import com.ruoyi.dealer.domain.dto.DealerBigScreenGroupResultRes;
import com.ruoyi.dealer.domain.dto.DealerRoundDetailListRes;
import com.ruoyi.dealer.mapper.DealerRoundResultMapper;
import com.ruoyi.dealer.service.IDealerBaseInfoService;
import com.ruoyi.dealer.service.IDealerRoundResultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

/**
 * 经销商轮次结果 Service 实现类
 */
@Service
public class DealerRoundResultServiceImpl extends ServiceImpl<DealerRoundResultMapper, DealerRoundResult> implements IDealerRoundResultService {
   @Autowired
    private IDealerBaseInfoService dealerBaseInfoService;

    @Override
    public List<DealerBigScreenGroupListRes> groupList(String CategoryName) {
        // 查询第一列分组的前几名
        List<DealerRoundResult> resultList = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getDealerCategory, CategoryName)
                .eq(DealerRoundResult::getRoundTime, 1)
                .orderByDesc(DealerRoundResult::getPaymentPercentage, DealerRoundResult::getPaymentTtl)
        );

        List<DealerBigScreenGroupListRes> list = new ArrayList<>();
        resultList.forEach(item -> {
            DealerBigScreenGroupListRes res = new DealerBigScreenGroupListRes();
            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setGroupName(item.getGroupName());
            res.setRoundTime(item.getRoundTime());
            res.setGoalTtlAct(item.getGoalTtlAct());
            res.setPaymentTtl(item.getPaymentTtl());

            res.setPaymentPercentage(getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 4) + "%");
            list.add(res);
        });

        return list;
    }

    @Override
    public List<DealerBigScreenGroupResultRes> groupTotalList() {
        List<DealerBigScreenGroupResultDto> dealerBigScreenGroupResultRes = this.getBaseMapper().groupTotalList();
        List<DealerBigScreenGroupResultRes> list = new ArrayList<>();
        dealerBigScreenGroupResultRes.forEach(item -> {
            DealerBigScreenGroupResultRes res = new DealerBigScreenGroupResultRes();
            res.setRoundTime(item.getRoundTime());
            res.setGroupName(item.getGroupName());
            res.setPaymentTtl(item.getPaymentTtl());
            res.setGoalTtlAct(item.getGoalTtlAct());

            res.setPaymentPercentage(new BigDecimal(item.getPaymentPercentage()).setScale(4, RoundingMode.HALF_UP).toString() + "%");
            list.add(res);
        });
        return list;
    }

    @Override
    public List<DealerRoundDetailListRes> groupRoundList(Integer roundTime, String phone, String dealerName) {
        List<DealerRoundResult> dealerBigScreenGroupResultRes = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, roundTime)
                .like(ObjectUtil.isNotEmpty(phone), DealerRoundResult::getPhone, phone)
                .like(ObjectUtil.isNotEmpty(dealerName), DealerRoundResult::getDealerName, dealerName)
                .orderByDesc(DealerRoundResult::getSalesRegionGroupName, DealerRoundResult::getPaymentPercentage));
        List<DealerRoundDetailListRes> list = new ArrayList<>();
        dealerBigScreenGroupResultRes.forEach(item -> {
            DealerRoundDetailListRes res = new DealerRoundDetailListRes();
            res.setRoundTime(item.getRoundTime());
            res.setGroupName(item.getGroupName());

            res.setDealerCategory(item.getDealerCategory());
            res.setDealerName(item.getDealerName());
            res.setDealerId(item.getDealerId());
            res.setPhone(item.getPhone());
            res.setPaymentTtl(item.getPaymentTtl());
            res.setGoalTtlAct(item.getGoalTtlAct());

            res.setPaymentPercentage(getPercentage(item.getPaymentTtl(), item.getGoalTtlAct(), 4) + "%");
            list.add(res);

        });


        return list;
    }

    @Override
    public int initRoundInfo() {
        List<DealerRoundResult> round1Results = this.list(new LambdaQueryWrapper<DealerRoundResult>()
                .eq(DealerRoundResult::getRoundTime, 1)
        );
        if(round1Results.size()>0){
            throw new RuntimeException("轮次数据已存在");
        }
        // 获取所有经销商信息
        List<DealerBaseInfo> resultList = dealerBaseInfoService.list();
        // 复制所有数据
        List<DealerRoundResult> roundResults  = new ArrayList<>();
        // 先清空id
        roundResults.forEach(item -> {
            item.setRoundTime(1);
            item.setDealerId(item.getDealerId());
            item.setResultId(null);
            item.setDealerName(item.getDealerName());
            item.setDealerCategory(item.getDealerCategory());
            item.setPhone(item.getPhone());
            item.setGoalTtlAct(item.getGoalTtlAct());
            item.setPaymentTtl(item.getPaymentTtl());
            item.setPaymentPercentage(item.getPaymentPercentage());

            // 覆盖字段
            item.setSalesRegionGroupName(item.getSalesRegionGroupName());
        });
        this.saveBatch(roundResults);
        return resultList.size();
    }

    private String getPercentage(Integer paymentTtl, Integer goalTtlAct,Integer scale) {
        return new BigDecimal(paymentTtl)
                .multiply(new BigDecimal(100))
                .divide(new BigDecimal(goalTtlAct),scale, RoundingMode.HALF_UP)
                .toString();
    }
}
