// 文件路径：ruoyi-system/src/main/java/com/ruoyi/dealer/mapper/DealerRoundResultMapper.java
package com.ruoyi.dealer.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.dealer.domain.DealerRoundResult;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

/**
 * 经销商轮次结果 Mapper 接口
 */
@Mapper
public interface DealerRoundResultMapper extends BaseMapper<DealerRoundResult> {
    /**
     * 查询组内达成率排前四名经销商列表
     * @param categoryName
     */
    @Select("select * from dealer_round_result where dealer_category = #{categoryName} and round_time = 1 " +
            "order by payment_percentage desc limit 4")
    void getGroupList(String categoryName);
    // 若需要自定义 SQL 方法，可在此添加
}
